/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreInterface;
import cadastre_fr.GeorefImage;
import cadastre_fr.ImageModifier;
import cadastre_fr.WMSLayer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

public class CadastreGrabber {
    public static final double epsilon = 1.0E-11;
    private CadastreInterface wmsInterface = new CadastreInterface(this);
    private String lastWMSLayerName = null;

    CadastreGrabber() {
        this.getWmsInterface().downloadCancelled = false;
    }

    public GeorefImage grab(WMSLayer wMSLayer, EastNorth eastNorth, EastNorth eastNorth2) throws IOException {
        try {
            URL uRL = null;
            uRL = wMSLayer.isRaster() ? this.getURLRaster(wMSLayer, eastNorth, eastNorth2) : this.getURLVector(eastNorth, eastNorth2);
            System.out.println("grab:" + uRL);
            BufferedImage bufferedImage = this.grab(uRL);
            ImageModifier imageModifier = new ImageModifier(bufferedImage);
            return new GeorefImage(imageModifier.bufferedImage, eastNorth, eastNorth2);
        }
        catch (MalformedURLException malformedURLException) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.")).initCause(malformedURLException);
        }
    }

    private URL getURLRaster(WMSLayer wMSLayer, EastNorth eastNorth, EastNorth eastNorth2) throws MalformedURLException {
        String string = new String(this.wmsInterface.baseURL + "/scpc/wms?version=1.1&request=GetMap");
        string = string + "&layers=CDIF:PMC@";
        string = string + wMSLayer.getCodeCommune();
        string = string + "&format=image/png";
        string = string + "&bbox=";
        string = string + wMSLayer.eastNorth2raster(eastNorth, eastNorth2);
        string = string + "&width=600&height=600";
        string = string + "&exception=application/vnd.ogc.se_inimage&styles=";
        return new URL(string.replace(" ", "%20"));
    }

    private URL getURLVector(EastNorth eastNorth, EastNorth eastNorth2) throws MalformedURLException {
        String string = new String(this.wmsInterface.baseURL + "/scpc/wms?version=1.1&request=GetMap");
        string = string + "&layers=CDIF:LS3,CDIF:LS2,CDIF:LS1,CDIF:PARCELLE,CDIF:NUMERO";
        string = string + ",CDIF:PT3,CDIF:PT2,CDIF:PT1,CDIF:LIEUDIT";
        string = string + ",CDIF:SUBSECTION";
        string = string + ",CDIF:SECTION";
        string = string + ",CDIF:COMMUNE";
        string = string + "&format=image/png";
        string = string + "&bbox=" + eastNorth.east() + ",";
        string = string + eastNorth.north() + ",";
        string = string + eastNorth2.east() + ",";
        string = string + eastNorth2.north();
        string = string + "&width=1000&height=800";
        string = string + "&styles=LS3_90,LS2_90,LS1_90,PARCELLE_90,NUMERO_90,PT3_90,PT2_90,PT1_90,LIEUDIT_90";
        string = string + ",SUBSECTION_90";
        string = string + ",SECTION_90";
        string = string + ",COMMUNE_90";
        System.out.println("URL=" + string);
        return new URL(string.replace(" ", "%20"));
    }

    private BufferedImage grab(URL uRL) throws IOException {
        this.wmsInterface.urlConn = (HttpURLConnection)uRL.openConnection();
        this.wmsInterface.urlConn.setRequestMethod("GET");
        this.wmsInterface.setCookie();
        ProgressInputStream progressInputStream = new ProgressInputStream((URLConnection)this.wmsInterface.urlConn, Main.pleaseWaitDlg);
        BufferedImage bufferedImage = ImageIO.read((InputStream)progressInputStream);
        progressInputStream.close();
        return bufferedImage;
    }

    public CadastreInterface getWmsInterface() {
        return this.wmsInterface;
    }

    public String getLastWMSLayerName() {
        return this.lastWMSLayerName;
    }

    public void setLastWMSLayerName(String string) {
        this.lastWMSLayerName = string;
    }
}

