/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.GeorefImage;
import cadastre_fr.WMSLayer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class CacheControl
implements Runnable {
    public static boolean cacheEnabled = true;
    public static int cacheSize = 500;
    public WMSLayer wmsLayer = null;
    private ArrayList<GeorefImage> imagesToSave = new ArrayList();
    private Lock imagesLock = new ReentrantLock();

    public CacheControl(WMSLayer wMSLayer) {
        cacheEnabled = Main.pref.getBoolean("cadastrewms.enableCaching", true);
        this.wmsLayer = wMSLayer;
        try {
            cacheSize = Integer.parseInt(Main.pref.get("cadastrewms.cacheSize", String.valueOf(500)));
        }
        catch (NumberFormatException numberFormatException) {
            cacheSize = 500;
        }
        File file = new File(CadastrePlugin.cacheDir);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            this.checkDirSize(file);
        }
        new Thread(this).start();
    }

    private void checkDirSize(File file) {
        long l = 0L;
        long l2 = Long.MAX_VALUE;
        int n = 0;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            l += fileArray[i].length();
            if (fileArray[i].lastModified() >= l2) continue;
            n = i;
            l2 = fileArray[i].lastModified();
        }
        if (l > (long)(cacheSize * 1024 * 1024)) {
            System.out.println("Delete oldest file  \"" + fileArray[n].getName() + "\" in cache dir to stay under the limit of " + cacheSize + " MB.");
            fileArray[n].delete();
            this.checkDirSize(file);
        }
    }

    public boolean loadCacheIfExist() {
        try {
            File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.name + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
            if (file.exists()) {
                int n = JOptionPane.showConfirmDialog(null, "Location \"" + this.wmsLayer.name + "\" found in cache.\n" + "Load cache first ?\n" + "(No = new cache)", "Location in cache", 0);
                if (n == 0) {
                    return this.loadCache(file, this.wmsLayer.lambertZone);
                }
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    public void deleteCacheFile() {
        try {
            File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.name + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public boolean loadCache(File file, int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            if (!this.wmsLayer.read(objectInputStream, n)) {
                return false;
            }
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
            return false;
        }
        return true;
    }

    public synchronized void saveCache(GeorefImage georefImage) {
        this.imagesLock.lock();
        this.imagesToSave.add(georefImage);
        this.notify();
        this.imagesLock.unlock();
    }

    public synchronized void run() {
        while (true) {
            this.imagesLock.lock();
            ArrayList<GeorefImage> arrayList = new ArrayList<GeorefImage>(this.imagesToSave);
            this.imagesToSave.clear();
            this.imagesLock.unlock();
            if (arrayList != null && !arrayList.isEmpty()) {
                File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.name + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
                try {
                    ObjectOutputStream objectOutputStream;
                    if (file.exists()) {
                        objectOutputStream = new ObjectOutputStreamAppend(new BufferedOutputStream(new FileOutputStream(file, true)));
                        for (GeorefImage georefImage : arrayList) {
                            objectOutputStream.writeObject(georefImage);
                        }
                        objectOutputStream.close();
                    } else {
                        objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        this.wmsLayer.write(objectOutputStream, arrayList);
                        objectOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.out);
                }
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    public class ObjectOutputStreamAppend
    extends ObjectOutputStream {
        public ObjectOutputStreamAppend(OutputStream outputStream) throws IOException {
            super(outputStream);
        }

        protected void writeStreamHeader() throws IOException {
            this.reset();
        }
    }
}

