/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static String getPluginDir() {
        return Main.pref.getPreferencesDir() + "plugins/validator/";
    }

    public static List<List<Way>> getWaysInCell(Way way, Map<Point2D, List<Way>> map) {
        if (way.nodes.size() == 0) {
            return Collections.emptyList();
        }
        Node node = (Node)way.nodes.get(0);
        Node node2 = (Node)way.nodes.get(way.nodes.size() - 1);
        ArrayList<List<Way>> arrayList = new ArrayList<List<Way>>(2);
        HashSet<Point2D.Double> hashSet = new HashSet<Point2D.Double>();
        long l = Math.round(node.eastNorth.east() * OSMValidatorPlugin.griddetail);
        long l2 = Math.round(node.eastNorth.north() * OSMValidatorPlugin.griddetail);
        long l3 = Math.round(node2.eastNorth.east() * OSMValidatorPlugin.griddetail);
        long l4 = Math.round(node2.eastNorth.north() * OSMValidatorPlugin.griddetail);
        Point2D.Double double_ = new Point2D.Double(l, l2);
        hashSet.add(double_);
        List<Way> list = map.get(double_);
        if (list == null) {
            list = new ArrayList<Way>();
            map.put(double_, list);
        }
        arrayList.add(list);
        double_ = new Point2D.Double(l3, l4);
        if (!hashSet.contains(double_)) {
            hashSet.add(double_);
            list = map.get(double_);
            if (list == null) {
                list = new ArrayList<Way>();
                map.put(double_, list);
            }
            arrayList.add(list);
        }
        l = (long)Math.floor(node.eastNorth.east() * OSMValidatorPlugin.griddetail);
        l2 = (long)Math.floor(node.eastNorth.north() * OSMValidatorPlugin.griddetail);
        l3 = (long)Math.floor(node2.eastNorth.east() * OSMValidatorPlugin.griddetail);
        l4 = (long)Math.floor(node2.eastNorth.north() * OSMValidatorPlugin.griddetail);
        double_ = new Point2D.Double(l, l2);
        if (!hashSet.contains(double_)) {
            hashSet.add(double_);
            list = map.get(double_);
            if (list == null) {
                list = new ArrayList<Way>();
                map.put(double_, list);
            }
            arrayList.add(list);
        }
        if (!hashSet.contains(double_ = new Point2D.Double(l3, l4))) {
            hashSet.add(double_);
            list = map.get(double_);
            if (list == null) {
                list = new ArrayList<Way>();
                map.put(double_, list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static List<Point2D> getSegmentCells(Node node, Node node2, double d) {
        double d2;
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        double d3 = node.eastNorth.east() * d;
        double d4 = node2.eastNorth.east() * d;
        double d5 = node.eastNorth.north() * d + 1.0;
        double d6 = node2.eastNorth.north() * d + 1.0;
        if (d3 > d4) {
            d2 = d3;
            d3 = d4;
            d4 = d2;
            d2 = d5;
            d5 = d6;
            d6 = d2;
        }
        d2 = d4 - d3;
        double d7 = d6 - d5;
        long l = d5 <= d6 ? 1L : -1L;
        long l2 = (long)Math.floor(d3);
        long l3 = (long)Math.floor(d4);
        long l4 = (long)Math.floor(d5);
        long l5 = (long)Math.floor(d6);
        long l6 = l3 - l2 + Math.abs(l5 - l4) + 1L;
        while (l2 <= l3 && (l4 - l5) * l <= 0L && l6-- > 0L) {
            arrayList.add(new Point2D.Double(l2, l4));
            double d8 = d7 / d2 * ((double)(l2 + 1L) - d4) + d6 + (double)(d7 < 0.0 ? -1 : 0);
            double d9 = d2 / d7 * ((double)(l4 + (long)(d7 < 0.0 ? 0 : 1) * l) - d6) + d4;
            double d10 = Math.pow((double)(l2 + 1L) - d3, 2.0) + Math.pow(d8 - d5, 2.0);
            double d11 = Math.pow(d9 - d3, 2.0) + Math.pow((double)(l4 + l) - d5, 2.0);
            if (d10 < d11) {
                ++l2;
                continue;
            }
            l4 += l;
        }
        return arrayList;
    }
}

