/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.util;

import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgregatePrimitivesVisitor
implements Visitor {
    Collection<OsmPrimitive> aggregatedData = new LinkedList<OsmPrimitive>();

    public Collection<OsmPrimitive> visit(Collection<OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.visit((Visitor)this);
        }
        return this.aggregatedData;
    }

    public void visit(Node node) {
        if (!this.aggregatedData.contains(node)) {
            this.aggregatedData.add((OsmPrimitive)node);
        }
    }

    public void visit(Way way) {
        if (!this.aggregatedData.contains(way)) {
            this.aggregatedData.add((OsmPrimitive)way);
            for (Node node : way.nodes) {
                this.visit(node);
            }
        }
    }

    public void visit(Relation relation) {
        if (!this.aggregatedData.contains(relation)) {
            this.aggregatedData.add((OsmPrimitive)relation);
            for (RelationMember relationMember : relation.members) {
                relationMember.member.visit((Visitor)this);
            }
        }
    }
}

