/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class WronglyOrderedWays
extends Test {
    protected static int WRONGLY_ORDERED_COAST = 1001;
    protected static int WRONGLY_ORDERED_WATER = 1002;
    protected static int WRONGLY_ORDERED_LAND = 1003;
    Bag<Way, Way> _errorWays;

    public WronglyOrderedWays() {
        super(I18n.tr((String)"Wrongly Ordered Ways."), I18n.tr((String)"This test checks the direction of water, land and coastline ways."));
    }

    public void startTest() {
        this._errorWays = new Bag();
    }

    public void endTest() {
        this._errorWays = null;
    }

    public void visit(Way way) {
        int n;
        String string = "";
        if (way.deleted || way.incomplete) {
            return;
        }
        String string2 = way.get("natural");
        if (string2 == null) {
            return;
        }
        if (string2.equals("coastline")) {
            string = I18n.tr((String)"Reversed coastline: land not on left side");
            n = WRONGLY_ORDERED_COAST;
        } else if (string2.equals("water")) {
            string = I18n.tr((String)"Reversed water: land not on left side");
            n = WRONGLY_ORDERED_WATER;
        } else if (string2.equals("land")) {
            string = I18n.tr((String)"Reversed land: land not on left side");
            n = WRONGLY_ORDERED_LAND;
        } else {
            return;
        }
        if (way.nodes.get(0) == way.nodes.get(way.nodes.size() - 1)) {
            double d = 0.0;
            for (int i = 1; i < way.nodes.size(); ++i) {
                d += ((Node)way.nodes.get((int)(i - 1))).coor.lon() * ((Node)way.nodes.get((int)i)).coor.lat() - ((Node)way.nodes.get((int)i)).coor.lon() * ((Node)way.nodes.get((int)(i - 1))).coor.lat();
            }
            if ((string2.equals("coastline") || string2.equals("land")) && d < 0.0 || string2.equals("water") && d > 0.0) {
                ArrayList<Way> arrayList = new ArrayList<Way>();
                arrayList.add(way);
                this.errors.add(new TestError((Test)this, Severity.WARNING, string, n, arrayList));
                this._errorWays.add(way, way);
            }
        }
    }
}

