/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedWay
extends Test {
    protected static final int EMPTY_WAY = 301;
    protected static final int UNTAGGED_WAY = 302;
    protected static final int UNNAMED_WAY = 303;
    protected static final int ONE_NODE_WAY = 304;
    private LinkedList<Way> multipolygonways;
    public static final Set<String> NAMED_WAYS = new HashSet<String>();

    public UntaggedWay() {
        super(I18n.tr((String)"Untagged, empty and one node ways."), I18n.tr((String)"This test checks for untagged, empty and one node ways."));
    }

    public void visit(Way way) {
        String string;
        if (way.deleted || way.incomplete) {
            return;
        }
        Map map = way.keys;
        if (map != null && (string = (String)map.get("highway")) != null && NAMED_WAYS.contains(string) && !map.containsKey("name") && !map.containsKey("ref")) {
            String string2;
            boolean bl = false;
            Iterator iterator = way.keySet().iterator();
            while (iterator.hasNext() && !(bl = (string2 = (String)iterator.next()).startsWith("name:") || string2.endsWith("_name") || string2.endsWith("_ref"))) {
            }
            if (!bl) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Unnamed ways"), 303, (OsmPrimitive)way));
            }
        }
        if (!way.tagged && !this.multipolygonways.contains(way)) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Untagged ways"), 302, (OsmPrimitive)way));
        }
        if (way.nodes.size() == 0) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Empty ways"), 301, (OsmPrimitive)way));
        } else if (way.nodes.size() == 1) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"One node ways"), 304, (OsmPrimitive)way));
        }
    }

    public void startTest() {
        this.multipolygonways = new LinkedList();
        for (Relation relation : Main.ds.relations) {
            if (relation.deleted || relation.incomplete || relation.keys == null || !"multipolygon".equals(relation.keys.get("type"))) continue;
            for (RelationMember relationMember : relation.members) {
                if (relationMember.member == null || !(relationMember.member instanceof Way) || relationMember.member.deleted || relationMember.member.incomplete || relationMember.member.tagged) continue;
                this.multipolygonways.add((Way)relationMember.member);
            }
        }
    }

    public void endTest() {
        this.multipolygonways = null;
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedWay) {
            return testError.getCode() == 301 || testError.getCode() == 304;
        }
        return false;
    }

    public Command fixError(TestError testError) {
        return DeleteCommand.delete(testError.getPrimitives());
    }

    static {
        NAMED_WAYS.add("motorway");
        NAMED_WAYS.add("trunk");
        NAMED_WAYS.add("primary");
        NAMED_WAYS.add("secondary");
        NAMED_WAYS.add("tertiary");
        NAMED_WAYS.add("residential");
        NAMED_WAYS.add("pedestrian");
    }
}

