/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconnectedWays
extends Test {
    protected static int UNCONNECTED_WAYS = 1301;
    protected static final String PREFIX = "validator." + UnconnectedWays.class.getSimpleName();
    Set<MyWaySegment> ways;
    Set<Node> endnodes;
    Set<Node> endnodes_highway;
    Set<Node> middlenodes;
    Set<Node> othernodes;
    double mindist;
    double minmiddledist;

    public UnconnectedWays() {
        super(I18n.tr((String)"Unconnected ways."), I18n.tr((String)"This test checks if a way has an endpoint very near to another way."));
    }

    @Override
    public void startTest() {
        this.ways = new HashSet<MyWaySegment>();
        this.endnodes = new HashSet<Node>();
        this.endnodes_highway = new HashSet<Node>();
        this.middlenodes = new HashSet<Node>();
        this.othernodes = new HashSet<Node>();
        this.mindist = Main.pref.getDouble(PREFIX + ".node_way_distance", 10.0) / 6378135.0;
        this.minmiddledist = Main.pref.getDouble(PREFIX + ".way_way_distance", 0.0) / 6378135.0;
    }

    @Override
    public void endTest() {
        HashMap<Node, Way> hashMap = new HashMap<Node, Way>();
        for (Node object : this.endnodes_highway) {
            for (MyWaySegment myWaySegment : this.ways) {
                if (!myWaySegment.highway.booleanValue() || !myWaySegment.nearby(object, this.mindist)) continue;
                hashMap.put(object, myWaySegment.w);
            }
        }
        if (hashMap.size() > 0) {
            for (Map.Entry entry : hashMap.entrySet()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Way end node near other highway"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
            }
        }
        hashMap.clear();
        for (Node node : this.endnodes_highway) {
            for (MyWaySegment myWaySegment : this.ways) {
                if (myWaySegment.highway.booleanValue() || !myWaySegment.nearby(node, this.mindist) || myWaySegment.isArea()) continue;
                hashMap.put(node, myWaySegment.w);
            }
        }
        for (Node node : this.endnodes) {
            for (MyWaySegment myWaySegment : this.ways) {
                if (!myWaySegment.nearby(node, this.mindist) || myWaySegment.isArea()) continue;
                hashMap.put(node, myWaySegment.w);
            }
        }
        if (hashMap.size() > 0) {
            for (Map.Entry entry : hashMap.entrySet()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Way end node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
            }
        }
        if (this.minmiddledist > 0.0) {
            hashMap.clear();
            for (Node node : this.middlenodes) {
                for (MyWaySegment myWaySegment : this.ways) {
                    if (!myWaySegment.nearby(node, this.minmiddledist)) continue;
                    hashMap.put(node, myWaySegment.w);
                }
            }
            if (hashMap.size() > 0) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Way node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
                }
            }
            hashMap.clear();
            for (Node node : this.othernodes) {
                for (MyWaySegment myWaySegment : this.ways) {
                    if (!myWaySegment.nearby(node, this.minmiddledist)) continue;
                    hashMap.put(node, myWaySegment.w);
                }
            }
            if (hashMap.size() > 0) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Connected way end node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
                }
            }
        }
        this.ways = null;
        this.endnodes = null;
    }

    @Override
    public void visit(Way way) {
        if (way.deleted || way.incomplete) {
            return;
        }
        int n = way.nodes.size();
        if (n < 2) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            if (i < n - 1) {
                this.addNode((Node)way.nodes.get(i), this.middlenodes);
            }
            this.ways.add(new MyWaySegment(way, (Node)way.nodes.get(i - 1), (Node)way.nodes.get(i)));
        }
        Set<Node> set = this.endnodes;
        if (way.get("highway") != null || way.get("railway") != null) {
            set = this.endnodes_highway;
        }
        this.addNode((Node)way.nodes.get(0), set);
        this.addNode((Node)way.nodes.get(n - 1), set);
    }

    private void addNode(Node node, Set<Node> set) {
        Boolean bl = this.middlenodes.contains(node);
        Boolean bl2 = this.endnodes.contains(node);
        Boolean bl3 = this.endnodes_highway.contains(node);
        Boolean bl4 = this.othernodes.contains(node);
        if (!(bl.booleanValue() || bl2.booleanValue() || bl4.booleanValue() || bl3.booleanValue())) {
            set.add(node);
        } else if (!bl4.booleanValue()) {
            this.othernodes.add(node);
            if (bl2.booleanValue()) {
                this.endnodes.remove(node);
            } else if (bl3.booleanValue()) {
                this.endnodes_highway.remove(node);
            } else {
                this.middlenodes.remove(node);
            }
        }
    }

    private class MyWaySegment {
        private Line2D line;
        public Way w;
        public Boolean highway;

        public MyWaySegment(Way way, Node node, Node node2) {
            this.w = way;
            this.highway = way.get("highway") != null || way.get("railway") != null;
            this.line = new Line2D.Double(node.eastNorth.east(), node.eastNorth.north(), node2.eastNorth.east(), node2.eastNorth.north());
        }

        public boolean nearby(Node node, double d) {
            return !this.w.nodes.contains(node) && this.line.ptSegDist(node.eastNorth.east(), node.eastNorth.north()) < d;
        }

        public boolean isArea() {
            return this.w.get("landuse") != null || this.w.get("leisure") != null || this.w.get("building") != null;
        }
    }
}

