/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class UnclosedWays
extends Test {
    Bag<Way, Way> _errorWays;
    private String type;
    private String etype;
    private int mode;
    private boolean force;

    public UnclosedWays() {
        super(I18n.tr((String)"Unclosed Ways."), I18n.tr((String)"This tests if ways which should be circular are closed."));
    }

    public void startTest() {
        this._errorWays = new Bag();
    }

    public void endTest() {
        this._errorWays = null;
    }

    public void set(boolean bl, int n, String string, String string2) {
        this.etype = MessageFormat.format(string, string2);
        this.type = I18n.tr((String)string, (Object[])new Object[]{I18n.tr((String)string2)});
        this.mode = n;
        this.force = bl;
    }

    public void set(boolean bl, int n, String string) {
        this.etype = string;
        this.type = I18n.tr((String)string);
        this.mode = n;
        this.force = bl;
    }

    public void visit(Way way) {
        Boolean bl;
        this.force = false;
        this.etype = null;
        this.type = null;
        this.mode = 0;
        if (way.deleted || way.incomplete) {
            return;
        }
        String string = way.get("natural");
        if (string != null) {
            this.set(!"coastline".equals(string), 1101, I18n.marktr((String)"natural type {0}"), string);
        }
        if ((string = way.get("landuse")) != null) {
            this.set(true, 1102, I18n.marktr((String)"landuse type {0}"), string);
        }
        if ((string = way.get("amenities")) != null) {
            this.set(true, 1103, I18n.marktr((String)"amenities type {0}"), string);
        }
        if ((string = way.get("sport")) != null && !string.equals("water_slide")) {
            this.set(true, 1104, I18n.marktr((String)"sport type {0}"), string);
        }
        if ((string = way.get("tourism")) != null) {
            this.set(true, 1105, I18n.marktr((String)"tourism type {0}"), string);
        }
        if ((string = way.get("shop")) != null) {
            this.set(true, 1106, I18n.marktr((String)"shop type {0}"), string);
        }
        if ((string = way.get("leisure")) != null) {
            this.set(true, 1107, I18n.marktr((String)"leisure type {0}"), string);
        }
        if ((string = way.get("waterway")) != null && string.equals("riverbank")) {
            this.set(true, 1108, I18n.marktr((String)"waterway type {0}"), string);
        }
        if ((bl = OsmUtils.getOsmBoolean((String)way.get("building"))) != null && bl.booleanValue()) {
            this.set(true, 1120, I18n.marktr((String)"building"));
        }
        if ((bl = OsmUtils.getOsmBoolean((String)way.get("area"))) != null && bl.booleanValue()) {
            this.set(true, 1130, I18n.marktr((String)"area"));
        }
        if (this.type != null && !way.isClosed().booleanValue()) {
            Node node = (Node)way.nodes.get(0);
            Node node2 = (Node)way.nodes.get(way.nodes.size() - 1);
            if (this.force || node.coor.greatCircleDistance(node2.coor) < 10000.0) {
                ArrayList<Way> arrayList = new ArrayList<Way>();
                ArrayList<Node> arrayList2 = new ArrayList<Node>();
                arrayList.add(way);
                arrayList2.add(node);
                arrayList2.add(node2);
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Unclosed way"), this.type, this.etype, this.mode, arrayList, arrayList2));
                this._errorWays.add(way, way);
            }
        }
    }
}

