/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.tests.ChangePropertyKeyCommand;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.plugins.validator.util.Entities;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagChecker
extends Test {
    public static final String DATA_FILE = "http://svn.openstreetmap.org/applications/editors/josm/plugins/validator/tagchecker.cfg";
    public static final String SPELL_FILE = "http://svn.openstreetmap.org/applications/utils/planet.osm/java/speller/words.cfg";
    protected static Map<String, String> spellCheckKeyData;
    protected static Bag<String, String> presetsValueData;
    protected static List<CheckerData> checkerData;
    protected static final String PREFIX;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_COMPLEX;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_CHECK_PAINT;
    public static final String PREF_SOURCES;
    public static final String PREF_USE_DATA_FILE;
    public static final String PREF_USE_SPELL_FILE;
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_COMPLEX_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_PAINT_BEFORE_UPLOAD;
    protected boolean checkKeys = false;
    protected boolean checkValues = false;
    protected boolean checkComplex = false;
    protected boolean checkFixmes = false;
    protected boolean checkPaint = false;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckComplex;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckPaint;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckComplexBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JCheckBox prefCheckPaintBeforeUpload;
    protected JCheckBox prefUseDataFile;
    protected JCheckBox prefUseSpellFile;
    protected JButton addSrcButton;
    protected JButton editSrcButton;
    protected JButton deleteSrcButton;
    protected static int EMPTY_VALUES;
    protected static int INVALID_KEY;
    protected static int INVALID_VALUE;
    protected static int FIXME;
    protected static int INVALID_SPACE;
    protected static int INVALID_KEY_SPACE;
    protected static int INVALID_HTML;
    protected static int PAINT;
    protected JList Sources;
    protected static Entities entities;

    public TagChecker() {
        super(I18n.tr((String)"Properties checker :"), I18n.tr((String)"This plugin checks for errors in property keys and values."));
    }

    public static void initialize(OSMValidatorPlugin oSMValidatorPlugin) throws Exception {
        TagChecker.initializeData();
        TagChecker.initializePresets();
    }

    private static void initializeData() throws IOException {
        spellCheckKeyData = new HashMap<String, String>();
        String string = Main.pref.get(PREF_SOURCES, "");
        if (Main.pref.getBoolean(PREF_USE_DATA_FILE, true)) {
            string = string == null || string.length() == 0 ? DATA_FILE : "http://svn.openstreetmap.org/applications/editors/josm/plugins/validator/tagchecker.cfg;" + string;
        }
        if (Main.pref.getBoolean(PREF_USE_SPELL_FILE, true)) {
            string = string == null || string.length() == 0 ? SPELL_FILE : "http://svn.openstreetmap.org/applications/utils/planet.osm/java/speller/words.cfg;" + string;
        }
        String string2 = "";
        if (string.length() == 0) {
            return;
        }
        for (String string3 : string.split(";")) {
            try {
                String string4;
                InputStreamReader inputStreamReader;
                MirroredInputStream mirroredInputStream = new MirroredInputStream(string3, Util.getPluginDir(), -1L);
                try {
                    inputStreamReader = new InputStreamReader((InputStream)mirroredInputStream, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    inputStreamReader = new InputStreamReader((InputStream)mirroredInputStream);
                }
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string5 = null;
                Boolean bl = false;
                while ((string4 = bufferedReader.readLine()) != null && (bl.booleanValue() || string4.length() != 0)) {
                    if (string4.startsWith("#")) {
                        if (!string4.startsWith("# JOSM TagChecker")) continue;
                        bl = true;
                        continue;
                    }
                    if (bl.booleanValue()) {
                        if (string4.length() <= 0) continue;
                        CheckerData checkerData = new CheckerData();
                        String string6 = checkerData.getData(string4);
                        if (string6 == null) {
                            TagChecker.checkerData.add(checkerData);
                            continue;
                        }
                        System.err.println(I18n.tr((String)"Invalid tagchecker line - {0}: {1}", (Object[])new Object[]{string6, string4}));
                        continue;
                    }
                    if (string4.charAt(0) == '+') {
                        string5 = string4.substring(1);
                        continue;
                    }
                    if (string4.charAt(0) == '-' && string5 != null) {
                        spellCheckKeyData.put(string4.substring(1), string5);
                        continue;
                    }
                    System.err.println(I18n.tr((String)"Invalid spellcheck line: {0}", (Object[])new Object[]{string4}));
                }
            }
            catch (IOException iOException) {
                string2 = string2 + string3 + "\n";
            }
        }
        if (string2.length() > 0) {
            throw new IOException(I18n.tr((String)"Could not access data file(s):\n{0}", (Object[])new Object[]{string2}));
        }
    }

    public static void initializePresets() throws Exception {
        if (!Main.pref.getBoolean(PREF_CHECK_VALUES, true)) {
            return;
        }
        Collection collection = TaggingPresetPreference.taggingPresets;
        if (collection != null) {
            presetsValueData = new Bag();
            for (TaggingPreset taggingPreset : collection) {
                for (TaggingPreset.Item item : taggingPreset.data) {
                    TaggingPreset.Combo combo;
                    if (item instanceof TaggingPreset.Combo) {
                        combo = (TaggingPreset.Combo)item;
                        for (String string : combo.values.split(",")) {
                            presetsValueData.add(combo.key, string);
                        }
                        continue;
                    }
                    if (!(item instanceof TaggingPreset.Key)) continue;
                    combo = (TaggingPreset.Key)item;
                    presetsValueData.add(combo.key, combo.value);
                }
            }
        }
    }

    @Override
    public void visit(Node node) {
        this.checkPrimitive((OsmPrimitive)node);
    }

    @Override
    public void visit(Relation relation) {
        this.checkPrimitive((OsmPrimitive)relation);
    }

    @Override
    public void visit(Way way) {
        this.checkPrimitive((OsmPrimitive)way);
    }

    private void checkPrimitive(OsmPrimitive osmPrimitive) {
        Bag<OsmPrimitive, String> bag = new Bag<OsmPrimitive, String>();
        if (this.checkComplex) {
            for (CheckerData object : checkerData) {
                if (!object.match(osmPrimitive).booleanValue()) continue;
                this.errors.add(new TestError((Test)this, object.getSeverity(), I18n.tr((String)"Illegal tag/value combinations"), object.getDescription(), object.getDescriptionOrig(), object.getCode(), osmPrimitive));
                bag.add(osmPrimitive, "TC");
                break;
            }
        }
        if (this.checkPaint && osmPrimitive.errors != null) {
            for (String string : osmPrimitive.errors) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Painting problem"), string, string, PAINT, osmPrimitive));
                bag.add(osmPrimitive, "P");
            }
        }
        Iterator iterator = osmPrimitive.keys == null ? Collections.emptyMap() : osmPrimitive.keys;
        for (Map.Entry entry : iterator.entrySet()) {
            String string = I18n.marktr((String)"Key ''{0}'' invalid.");
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (this.checkValues && (string3 == null || string3.trim().length() == 0) && !bag.contains(osmPrimitive, "EV")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Tags with empty values"), I18n.tr((String)string, (Object[])new Object[]{string2}), MessageFormat.format(string, string2), EMPTY_VALUES, osmPrimitive));
                bag.add(osmPrimitive, "EV");
            }
            if (this.checkKeys && spellCheckKeyData.containsKey(string2) && !bag.contains(osmPrimitive, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Invalid property key"), I18n.tr((String)string, (Object[])new Object[]{string2}), MessageFormat.format(string, string2), INVALID_KEY, osmPrimitive));
                bag.add(osmPrimitive, "IPK");
            }
            if (this.checkKeys && string2.indexOf(" ") >= 0 && !bag.contains(osmPrimitive, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Invalid white space in property key"), I18n.tr((String)string, (Object[])new Object[]{string2}), MessageFormat.format(string, string2), INVALID_KEY_SPACE, osmPrimitive));
                bag.add(osmPrimitive, "IPK");
            }
            if (this.checkValues && string3 != null && (string3.startsWith(" ") || string3.endsWith(" ")) && !bag.contains(osmPrimitive, "SPACE")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Property values start or end with white space"), I18n.tr((String)string, (Object[])new Object[]{string2}), MessageFormat.format(string, string2), INVALID_SPACE, osmPrimitive));
                bag.add(osmPrimitive, "SPACE");
            }
            if (this.checkValues && string3 != null && !string3.equals(entities.unescape(string3)) && !bag.contains(osmPrimitive, "HTML")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Property values contain HTML entity"), I18n.tr((String)string, (Object[])new Object[]{string2}), MessageFormat.format(string, string2), INVALID_HTML, osmPrimitive));
                bag.add(osmPrimitive, "HTML");
            }
            if (this.checkValues && string3 != null && string3.length() > 0 && presetsValueData != null) {
                String string4;
                List<String> list = presetsValueData.get(string2);
                if (list == null) {
                    string4 = I18n.marktr((String)"Key ''{0}'' not in presets.");
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Presets do not contain property key"), I18n.tr((String)string4, (Object[])new Object[]{string2}), MessageFormat.format(string4, string2), INVALID_VALUE, osmPrimitive));
                    bag.add(osmPrimitive, "UPK");
                } else if (!list.contains(entry.getValue())) {
                    string4 = I18n.marktr((String)"Value ''{0}'' for key ''{1}'' not in presets.");
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Presets do not contain property value"), I18n.tr((String)string4, (Object[])new Object[]{entry.getValue(), string2}), MessageFormat.format(string4, entry.getValue(), string2), INVALID_VALUE, osmPrimitive));
                    bag.add(osmPrimitive, "UPV");
                }
            }
            if (!this.checkFixmes || string3 == null || string3.length() <= 0 || !string3.contains("FIXME") && !string3.contains("check and delete") && !string2.contains("todo") && !string2.contains("fixme") || bag.contains(osmPrimitive, "FIXME")) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"FIXMES"), FIXME, osmPrimitive));
            bag.add(osmPrimitive, "FIXME");
        }
    }

    @Override
    public void startTest() {
        this.checkKeys = Main.pref.getBoolean(PREF_CHECK_KEYS, true);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Main.pref.getBoolean(PREF_CHECK_VALUES, true);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkComplex = Main.pref.getBoolean(PREF_CHECK_COMPLEX, true);
        if (this.isBeforeUpload) {
            this.checkComplex = this.checkValues && Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true);
        }
        this.checkFixmes = Main.pref.getBoolean(PREF_CHECK_FIXMES, true);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
        this.checkPaint = Main.pref.getBoolean(PREF_CHECK_PAINT, true);
        if (this.isBeforeUpload) {
            this.checkPaint = this.checkPaint && Main.pref.getBoolean(PREF_CHECK_PAINT_BEFORE_UPLOAD, true);
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> collection) {
        if (this.checkKeys || this.checkValues || this.checkComplex) {
            super.visit(collection);
        }
    }

    @Override
    public void addGui(JPanel jPanel) {
        GBC gBC = GBC.eol();
        gBC.anchor = 13;
        jPanel.add((Component)new JLabel(this.name), GBC.eol().insets(3, 0, 0, 0));
        this.prefCheckKeys = new JCheckBox(I18n.tr((String)"Check property keys."), Main.pref.getBoolean(PREF_CHECK_KEYS, true));
        this.prefCheckKeys.setToolTipText(I18n.tr((String)"Validate that property keys are valid checking against list of words."));
        jPanel.add((Component)this.prefCheckKeys, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckKeysBeforeUpload, gBC);
        this.prefCheckComplex = new JCheckBox(I18n.tr((String)"Use complex property checker."), Main.pref.getBoolean(PREF_CHECK_COMPLEX, true));
        this.prefCheckComplex.setToolTipText(I18n.tr((String)"Validate property values and tags using complex rules."));
        jPanel.add((Component)this.prefCheckComplex, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckComplexBeforeUpload = new JCheckBox();
        this.prefCheckComplexBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckComplexBeforeUpload, gBC);
        this.Sources = new JList(new DefaultListModel());
        String string = Main.pref.get(PREF_SOURCES);
        if (string != null && string.length() > 0) {
            for (String string2 : string.split(";")) {
                ((DefaultListModel)this.Sources.getModel()).addElement(string2);
            }
        }
        this.addSrcButton = new JButton(I18n.tr((String)"Add"));
        this.addSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"TagChecker source"));
                if (string != null) {
                    ((DefaultListModel)TagChecker.this.Sources.getModel()).addElement(string);
                }
                TagChecker.this.Sources.clearSelection();
            }
        });
        this.editSrcButton = new JButton(I18n.tr((String)"Edit"));
        this.editSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TagChecker.this.Sources.getSelectedIndex();
                if (n == -1 && TagChecker.this.Sources.getModel().getSize() == 1) {
                    TagChecker.this.Sources.setSelectedIndex(0);
                    n = 0;
                }
                if (n == -1) {
                    if (TagChecker.this.Sources.getModel().getSize() == 0) {
                        String string = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"TagChecker source"));
                        if (string != null) {
                            ((DefaultListModel)TagChecker.this.Sources.getModel()).addElement(string);
                        }
                    } else {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the row to edit."));
                    }
                } else {
                    String string = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"TagChecker source"), TagChecker.this.Sources.getSelectedValue());
                    if (string != null) {
                        ((DefaultListModel)TagChecker.this.Sources.getModel()).setElementAt(string, n);
                    }
                }
                TagChecker.this.Sources.clearSelection();
            }
        });
        this.deleteSrcButton = new JButton(I18n.tr((String)"Delete"));
        this.deleteSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TagChecker.this.Sources.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the row to delete."));
                } else {
                    ((DefaultListModel)TagChecker.this.Sources.getModel()).remove(TagChecker.this.Sources.getSelectedIndex());
                }
            }
        });
        this.Sources.setMinimumSize(new Dimension(300, 50));
        this.Sources.setVisibleRowCount(3);
        this.Sources.setToolTipText(I18n.tr((String)"The sources (URL or filename) of spell check (see http://wiki.openstreetmap.org/index.php/User:JLS/speller) or tag checking data files."));
        this.addSrcButton.setToolTipText(I18n.tr((String)"Add a new source to the list."));
        this.editSrcButton.setToolTipText(I18n.tr((String)"Edit the selected source."));
        this.deleteSrcButton.setToolTipText(I18n.tr((String)"Delete the selected source from the list."));
        jPanel.add((Component)new JLabel(I18n.tr((String)"Data sources")), GBC.eol().insets(23, 0, 0, 0));
        jPanel.add((Component)new JScrollPane(this.Sources), GBC.eol().insets(23, 0, 0, 0).fill(2));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, GBC.eol().fill(2));
        jPanel2.add((Component)this.addSrcButton, GBC.std().insets(0, 5, 0, 0));
        jPanel2.add((Component)this.editSrcButton, GBC.std().insets(5, 5, 5, 0));
        jPanel2.add((Component)this.deleteSrcButton, GBC.std().insets(0, 5, 0, 0));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagChecker.this.handlePrefEnable();
            }
        };
        this.prefCheckKeys.addActionListener(actionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(actionListener);
        this.prefCheckComplex.addActionListener(actionListener);
        this.prefCheckComplexBeforeUpload.addActionListener(actionListener);
        this.handlePrefEnable();
        this.prefCheckValues = new JCheckBox(I18n.tr((String)"Check property values."), Main.pref.getBoolean(PREF_CHECK_VALUES, true));
        this.prefCheckValues.setToolTipText(I18n.tr((String)"Validate that property values are valid checking against presets."));
        jPanel.add((Component)this.prefCheckValues, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckValuesBeforeUpload, gBC);
        this.prefCheckFixmes = new JCheckBox(I18n.tr((String)"Check for FIXMES."), Main.pref.getBoolean(PREF_CHECK_FIXMES, true));
        this.prefCheckFixmes.setToolTipText(I18n.tr((String)"Looks for nodes or ways with FIXME in any property value."));
        jPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckFixmesBeforeUpload, gBC);
        this.prefCheckPaint = new JCheckBox(I18n.tr((String)"Check for paint notes."), Main.pref.getBoolean(PREF_CHECK_PAINT, true));
        this.prefCheckPaint.setToolTipText(I18n.tr((String)"Check if map painting found data errors."));
        jPanel.add((Component)this.prefCheckPaint, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckPaintBeforeUpload = new JCheckBox();
        this.prefCheckPaintBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_PAINT_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckPaintBeforeUpload, gBC);
        this.prefUseDataFile = new JCheckBox(I18n.tr((String)"Use default data file."), Main.pref.getBoolean(PREF_USE_DATA_FILE, true));
        this.prefUseDataFile.setToolTipText(I18n.tr((String)"Use the default data file (recommended)."));
        jPanel.add((Component)this.prefUseDataFile, GBC.eol().insets(20, 0, 0, 0));
        this.prefUseSpellFile = new JCheckBox(I18n.tr((String)"Use default spellcheck file."), Main.pref.getBoolean(PREF_USE_SPELL_FILE, true));
        this.prefUseSpellFile.setToolTipText(I18n.tr((String)"Use the default spellcheck file (recommended)."));
        jPanel.add((Component)this.prefUseSpellFile, GBC.eol().insets(20, 0, 0, 0));
    }

    public void handlePrefEnable() {
        boolean bl = this.prefCheckKeys.isSelected() || this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        this.Sources.setEnabled(bl);
        this.addSrcButton.setEnabled(bl);
        this.editSrcButton.setEnabled(bl);
        this.deleteSrcButton.setEnabled(bl);
    }

    @Override
    public boolean ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        Main.pref.put(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX, this.prefCheckComplex.isSelected());
        Main.pref.put(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Main.pref.put(PREF_CHECK_PAINT, this.prefCheckPaint.isSelected());
        Main.pref.put(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, this.prefCheckComplexBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_PAINT_BEFORE_UPLOAD, this.prefCheckPaintBeforeUpload.isSelected());
        Main.pref.put(PREF_USE_DATA_FILE, this.prefUseDataFile.isSelected());
        Main.pref.put(PREF_USE_SPELL_FILE, this.prefUseSpellFile.isSelected());
        String string = "";
        if (this.Sources.getModel().getSize() > 0) {
            String string2 = "";
            for (int i = 0; i < this.Sources.getModel().getSize(); ++i) {
                string2 = string2 + ";" + this.Sources.getModel().getElementAt(i);
            }
            string = string2.substring(1);
        }
        if (string.length() == 0) {
            string = null;
        }
        return Main.pref.put(PREF_SOURCES, string);
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Object> arrayList = new ArrayList<Object>(50);
        int n = -1;
        List<? extends OsmPrimitive> list = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : list) {
            ++n;
            Map map = osmPrimitive.keys;
            if (map == null || map.size() == 0) continue;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string2 == null || string2.trim().length() == 0) {
                    arrayList.add(new ChangePropertyCommand(Collections.singleton(list.get(n)), string, null));
                    continue;
                }
                if (string2.startsWith(" ") || string2.endsWith(" ")) {
                    arrayList.add(new ChangePropertyCommand(Collections.singleton(list.get(n)), string, string2.trim()));
                    continue;
                }
                if (string.startsWith(" ") || string.endsWith(" ")) {
                    arrayList.add((Object)new ChangePropertyKeyCommand(Collections.singleton(list.get(n)), string, string.trim()));
                    continue;
                }
                String string3 = entities.unescape(string2);
                if (!string3.equals(string2)) {
                    arrayList.add(new ChangePropertyCommand(Collections.singleton(list.get(n)), string, string3));
                    continue;
                }
                String string4 = spellCheckKeyData.get(string);
                if (string4 == null) continue;
                arrayList.add((Object)new ChangePropertyKeyCommand(Collections.singleton(list.get(n)), string, string4));
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Command)arrayList.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Fix properties"), arrayList);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof TagChecker) {
            int n = testError.getCode();
            return n == INVALID_KEY || n == EMPTY_VALUES || n == INVALID_SPACE || n == INVALID_KEY_SPACE || n == INVALID_HTML;
        }
        return false;
    }

    static {
        checkerData = new ArrayList<CheckerData>();
        PREFIX = "validator." + TagChecker.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_COMPLEX = PREFIX + ".checkComplex";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_CHECK_PAINT = PREFIX + ".paint";
        PREF_SOURCES = PREFIX + ".sources";
        PREF_USE_DATA_FILE = PREFIX + ".usedatafile";
        PREF_USE_SPELL_FILE = PREFIX + ".usespellfile";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREF_CHECK_KEYS + "BeforeUpload";
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREF_CHECK_VALUES + "BeforeUpload";
        PREF_CHECK_COMPLEX_BEFORE_UPLOAD = PREF_CHECK_COMPLEX + "BeforeUpload";
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREF_CHECK_FIXMES + "BeforeUpload";
        PREF_CHECK_PAINT_BEFORE_UPLOAD = PREF_CHECK_PAINT + "BeforeUpload";
        EMPTY_VALUES = 1200;
        INVALID_KEY = 1201;
        INVALID_VALUE = 1202;
        FIXME = 1203;
        INVALID_SPACE = 1204;
        INVALID_KEY_SPACE = 1205;
        INVALID_HTML = 1206;
        PAINT = 1207;
        entities = new Entities();
    }

    private static class CheckerData {
        private String description;
        private List<CheckerElement> data = new ArrayList<CheckerElement>();
        private Integer type = 0;
        private Integer code;
        protected Severity severity;
        protected static int NODE = 1;
        protected static int WAY = 2;
        protected static int RELATION = 3;
        protected static int ALL = 4;
        protected static int TAG_CHECK_ERROR = 1250;
        protected static int TAG_CHECK_WARN = 1260;
        protected static int TAG_CHECK_INFO = 1270;

        private CheckerData() {
        }

        public String getData(String string) {
            Matcher matcher = Pattern.compile(" *# *([^#]+) *$").matcher(string);
            string = matcher.replaceFirst("").trim();
            try {
                this.description = matcher.group(1);
                if (this.description != null && this.description.length() == 0) {
                    this.description = null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.description = null;
            }
            String[] stringArray = string.split(" *: *", 3);
            if (stringArray[0].equals("way")) {
                this.type = WAY;
            } else if (stringArray[0].equals("node")) {
                this.type = NODE;
            } else if (stringArray[0].equals("relation")) {
                this.type = RELATION;
            } else if (stringArray[0].equals("*")) {
                this.type = ALL;
            }
            if (this.type == 0 || stringArray.length != 3) {
                return I18n.tr((String)"Could not find element type");
            }
            if (stringArray[1].equals("W")) {
                this.severity = Severity.WARNING;
                this.code = TAG_CHECK_WARN;
            } else if (stringArray[1].equals("E")) {
                this.severity = Severity.ERROR;
                this.code = TAG_CHECK_ERROR;
            } else if (stringArray[1].equals("I")) {
                this.severity = Severity.OTHER;
                this.code = TAG_CHECK_INFO;
            } else {
                return I18n.tr((String)"Could not find warning level");
            }
            for (String string2 : stringArray[2].split(" *&& *")) {
                try {
                    this.data.add(new CheckerElement(string2));
                }
                catch (IllegalStateException illegalStateException) {
                    return I18n.tr((String)"Illegal expression ''{0}''", (Object[])new Object[]{string2});
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return I18n.tr((String)"Illegal regular expression ''{0}''", (Object[])new Object[]{string2});
                }
            }
            return null;
        }

        public Boolean match(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.keys == null || this.type == NODE && !(osmPrimitive instanceof Node) || this.type == RELATION && !(osmPrimitive instanceof Relation) || this.type == WAY && !(osmPrimitive instanceof Way)) {
                return false;
            }
            for (CheckerElement checkerElement : this.data) {
                if (checkerElement.match(osmPrimitive).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return I18n.tr((String)this.description);
        }

        public String getDescriptionOrig() {
            return this.description;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public int getCode() {
            return this.code + this.type;
        }

        private class CheckerElement {
            public Object tag;
            public Object value;
            public Boolean noMatch;
            public Boolean tagAll = false;
            public Boolean valueAll = false;
            public Boolean valueBool = false;

            private Pattern getPattern(String string) throws IllegalStateException, PatternSyntaxException {
                if (string.endsWith("/i")) {
                    return Pattern.compile(string.substring(1, string.length() - 2), 2);
                }
                if (string.endsWith("/")) {
                    return Pattern.compile(string.substring(1, string.length() - 1));
                }
                throw new IllegalStateException();
            }

            public CheckerElement(String string) throws IllegalStateException, PatternSyntaxException {
                Matcher matcher = Pattern.compile("(.+)([!=]=)(.+)").matcher(string);
                matcher.matches();
                String string2 = matcher.group(1).trim();
                if (string2.equals("*")) {
                    this.tagAll = true;
                } else {
                    this.tag = string2.startsWith("/") ? this.getPattern(string2) : string2;
                }
                this.noMatch = matcher.group(2).equals("!=");
                string2 = matcher.group(3).trim();
                if (string2.equals("*")) {
                    this.valueAll = true;
                } else if (string2.equals("BOOLEAN_TRUE")) {
                    this.valueBool = true;
                    this.value = "yes";
                } else if (string2.equals("BOOLEAN_FALSE")) {
                    this.valueBool = true;
                    this.value = "no";
                } else {
                    this.value = string2.startsWith("/") ? this.getPattern(string2) : string2;
                }
            }

            public Boolean match(OsmPrimitive osmPrimitive) {
                for (Map.Entry entry : osmPrimitive.keys.entrySet()) {
                    String string;
                    String string2 = (String)entry.getKey();
                    String string3 = string = this.valueBool != false ? OsmUtils.getNamedOsmBoolean((String)((String)entry.getValue())) : (String)entry.getValue();
                    if (!this.tagAll.booleanValue() && !(this.tag instanceof Pattern ? ((Pattern)this.tag).matcher(string2).matches() : string2.equals(this.tag)) || !this.valueAll.booleanValue() && !(this.value instanceof Pattern ? ((Pattern)this.value).matcher(string).matches() : string.equals(this.value))) continue;
                    return this.noMatch == false;
                }
                return this.noMatch;
            }
        }
    }
}

