/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Arrays;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class SelfIntersectingWay
extends Test {
    protected static int SELF_INTERSECT = 401;

    public SelfIntersectingWay() {
        super(I18n.tr((String)"Self-intersecting ways"), I18n.tr((String)"This test checks for ways that contain some of their nodes more than once."));
    }

    public void visit(Way way) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (int i = 1; i < way.nodes.size() - 1; ++i) {
            Node node = (Node)way.nodes.get(i);
            if (hashSet.contains(node)) {
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Self-intersecting ways"), SELF_INTERSECT, Arrays.asList(way), Arrays.asList(node)));
                break;
            }
            hashSet.add(node);
        }
    }
}

