/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class NodesWithSameName
extends Test {
    protected static int SAME_NAME = 801;
    private Map<String, List<Node>> namesToNodes;

    public NodesWithSameName() {
        super(I18n.tr((String)"Nodes with same name"), I18n.tr((String)"This test finds nodes that have the same name (might be duplicates)."));
    }

    public void startTest() {
        this.namesToNodes = new HashMap<String, List<Node>>();
    }

    public void visit(Node node) {
        if (node.deleted || node.incomplete) {
            return;
        }
        String string = node.get("name");
        String string2 = node.get("traffic_sign");
        if (string == null || string2 != null && string2.equals("city_limit")) {
            return;
        }
        List<Node> list = this.namesToNodes.get(string);
        if (list == null) {
            list = new ArrayList<Node>();
            this.namesToNodes.put(string, list);
        }
        list.add(node);
    }

    public void endTest() {
        for (List<Node> list : this.namesToNodes.values()) {
            if (list.size() <= 1) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Nodes with same name"), SAME_NAME, list));
        }
        this.namesToNodes = null;
    }
}

