/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Arrays;
import java.util.Collections;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class DuplicatedWayNodes
extends Test {
    protected static int DUPLICATE_WAY_NODE = 501;

    public DuplicatedWayNodes() {
        super(I18n.tr((String)"Duplicated way nodes."), I18n.tr((String)"Checks for ways with identical consecutive nodes."));
    }

    public void visit(Way way) {
        if (way.deleted || way.incomplete) {
            return;
        }
        Node node = null;
        for (Node node2 : way.nodes) {
            if (node == null) {
                node = node2;
                continue;
            }
            if (node == node2) {
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Duplicated way nodes"), DUPLICATE_WAY_NODE, Arrays.asList(way), Arrays.asList(node2)));
                break;
            }
            node = node2;
        }
    }

    public Command fixError(TestError testError) {
        Way way = (Way)testError.getPrimitives().iterator().next();
        Way way2 = new Way(way);
        way2.nodes.clear();
        Node node = null;
        for (Node node2 : way.nodes) {
            if (node == null) {
                way2.nodes.add(node2);
            } else if (node2 != node) {
                way2.nodes.add(node2);
            }
            node = node2;
        }
        if (way2.nodes.size() < 2) {
            return DeleteCommand.delete(Collections.singleton(way));
        }
        return new ChangeCommand((OsmPrimitive)way, (OsmPrimitive)way2);
    }

    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicatedWayNodes;
    }
}

