/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class DuplicateNode
extends Test {
    protected static int DUPLICATE_NODE = 1;
    Bag<LatLon, OsmPrimitive> nodes;

    public DuplicateNode() {
        super(I18n.tr((String)"Duplicated nodes") + ".", I18n.tr((String)"This test checks that there are no nodes at the very same location."));
    }

    public void startTest() {
        this.nodes = new Bag(1000);
    }

    public void endTest() {
        for (List list : this.nodes.values()) {
            if (list.size() <= 1) continue;
            TestError testError = new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), DUPLICATE_NODE, list);
            this.errors.add(testError);
        }
        this.nodes = null;
    }

    public void visit(Node node) {
        if (!node.deleted && !node.incomplete) {
            this.nodes.add(node.coor, (OsmPrimitive)node);
        }
    }

    public Command fixError(TestError testError) {
        List<? extends OsmPrimitive> list = testError.getPrimitives();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (OsmPrimitive object : list) {
            if (!(object instanceof Node)) continue;
            linkedList.add((Node)object);
        }
        if (linkedList.size() < 2) {
            return null;
        }
        Node node = null;
        for (Node node2 : linkedList) {
            if (node2.id <= 0L) continue;
            node = node2;
            break;
        }
        if (node == null) {
            node = (Node)linkedList.iterator().next();
        }
        MergeNodesAction.mergeNodes(linkedList, node);
        return null;
    }

    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicateNode;
    }
}

