/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossingWays
extends Test {
    protected static int CROSSING_WAYS = 601;
    Map<Point2D, List<ExtendedSegment>> cellSegments;
    HashSet<WaySegment> errorSegments;
    Map<List<Way>, List<WaySegment>> ways_seen;

    public CrossingWays() {
        super(I18n.tr((String)"Crossing ways."), I18n.tr((String)"This test checks if two roads, railways or waterways crosses in the same layer, but are not connected by a node."));
    }

    @Override
    public void startTest() {
        this.cellSegments = new HashMap<Point2D, List<ExtendedSegment>>(1000);
        this.errorSegments = new HashSet();
        this.ways_seen = new HashMap<List<Way>, List<WaySegment>>(50);
    }

    @Override
    public void endTest() {
        this.cellSegments = null;
        this.errorSegments = null;
        this.ways_seen = null;
    }

    @Override
    public void visit(Way way) {
        boolean bl;
        if (way.deleted || way.incomplete) {
            return;
        }
        String string = way.get("natural");
        boolean bl2 = string != null && (string.equals("water") || string.equals("coastline"));
        String string2 = way.get("railway");
        boolean bl3 = bl = string2 != null && string2.equals("subway");
        if (way.get("highway") == null && way.get("waterway") == null && (string2 == null || bl) && !bl2) {
            return;
        }
        String string3 = way.get("layer");
        int n = way.nodes.size();
        for (int i = 0; i < n - 1; ++i) {
            WaySegment waySegment = new WaySegment(way, i);
            ExtendedSegment extendedSegment = new ExtendedSegment(waySegment, string3, string2, string);
            List<List<ExtendedSegment>> list = this.getSegments(extendedSegment.n1, extendedSegment.n2);
            for (List<ExtendedSegment> list2 : list) {
                for (ExtendedSegment extendedSegment2 : list2) {
                    boolean bl4;
                    if (this.errorSegments.contains(waySegment) && this.errorSegments.contains(extendedSegment2.ws)) continue;
                    String string4 = extendedSegment2.layer;
                    String string5 = extendedSegment2.railway;
                    String string6 = extendedSegment2.coastline;
                    if (string3 != null ? !string3.equals(string4) : string4 != null) continue;
                    if (!extendedSegment.intersects(extendedSegment2) || bl && "subway".equals(string5)) continue;
                    boolean bl5 = bl4 = string6 != null && (string6.equals("water") || string6.equals("coastline"));
                    if (bl2 != bl4) continue;
                    List<Way> list3 = Arrays.asList(extendedSegment.ws.way, extendedSegment2.ws.way);
                    List<WaySegment> list4 = this.ways_seen.get(list3);
                    if (list4 == null) {
                        list4 = new ArrayList<WaySegment>();
                        list4.add(extendedSegment.ws);
                        list4.add(extendedSegment2.ws);
                        this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Crossing ways"), CROSSING_WAYS, list3, list4));
                        this.ways_seen.put(list3, list4);
                        continue;
                    }
                    list4.add(extendedSegment.ws);
                    list4.add(extendedSegment2.ws);
                }
                list2.add(extendedSegment);
            }
        }
    }

    public List<List<ExtendedSegment>> getSegments(Node node, Node node2) {
        ArrayList<List<ExtendedSegment>> arrayList = new ArrayList<List<ExtendedSegment>>();
        for (Point2D point2D : Util.getSegmentCells(node, node2, OSMValidatorPlugin.griddetail)) {
            List<ExtendedSegment> list = this.cellSegments.get(point2D);
            if (list == null) {
                list = new ArrayList<ExtendedSegment>();
                this.cellSegments.put(point2D, list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    private class ExtendedSegment {
        public Node n1;
        public Node n2;
        public WaySegment ws;
        public String layer;
        public String railway;
        public String coastline;

        public ExtendedSegment(WaySegment waySegment, String string, String string2, String string3) {
            this.ws = waySegment;
            this.n1 = (Node)waySegment.way.nodes.get(waySegment.lowerIndex);
            this.n2 = (Node)waySegment.way.nodes.get(waySegment.lowerIndex + 1);
            this.layer = string;
            this.railway = string2;
            this.coastline = string3;
        }

        public boolean intersects(ExtendedSegment extendedSegment) {
            if (this.n1.equals((Object)extendedSegment.n1) || this.n2.equals((Object)extendedSegment.n2) || this.n1.equals((Object)extendedSegment.n2) || this.n2.equals((Object)extendedSegment.n1)) {
                return false;
            }
            return Line2D.linesIntersect(this.n1.eastNorth.east(), this.n1.eastNorth.north(), this.n2.eastNorth.east(), this.n2.eastNorth.north(), extendedSegment.n1.eastNorth.east(), extendedSegment.n1.eastNorth.north(), extendedSegment.n2.eastNorth.east(), extendedSegment.n2.eastNorth.north());
        }
    }
}

