/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static int UNORDERED_COASTLINES = 901;
    Map<Point2D, List<Way>> _cellWays;
    Bag<Way, Way> _errorWays;

    public Coastlines() {
        super(I18n.tr((String)"Coastlines."), I18n.tr((String)"This test checks that coastlines are correct."));
    }

    public void startTest() {
        this._cellWays = new HashMap<Point2D, List<Way>>(1000);
        this._errorWays = new Bag();
    }

    public void endTest() {
        this._cellWays = null;
        this._errorWays = null;
    }

    public void visit(Way way) {
        if (way.deleted || way.incomplete) {
            return;
        }
        String string = way.get("natural");
        if (string == null || !string.equals("coastline")) {
            return;
        }
        List<List<Way>> list = Util.getWaysInCell(way, this._cellWays);
        for (List<Way> list2 : list) {
            for (Way way2 : list2) {
                String string2;
                if (this._errorWays.contains(way, way2) || this._errorWays.contains(way2, way) || (string2 = way.get("natural")) == null || !string2.equals("coastline") || !((Node)way.nodes.get(0)).equals(way2.nodes.get(0)) && !((Node)way.nodes.get(way.nodes.size() - 1)).equals(way2.nodes.get(way2.nodes.size() - 1))) continue;
                ArrayList<Way> arrayList = new ArrayList<Way>();
                arrayList.add(way);
                arrayList.add(way2);
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Unordered coastline"), UNORDERED_COASTLINES, arrayList));
                this._errorWays.add(way, way2);
            }
            list2.add(way);
        }
    }
}

