/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePropertyKeyCommand
extends Command {
    private final List<OsmPrimitive> objects;
    private final String key;
    private final String newKey;

    public ChangePropertyKeyCommand(Collection<? extends OsmPrimitive> collection, String string, String string2) {
        this.objects = new LinkedList<OsmPrimitive>(collection);
        this.key = string;
        this.newKey = string2;
    }

    public boolean executeCommand() {
        if (!super.executeCommand()) {
            return false;
        }
        for (OsmPrimitive osmPrimitive : this.objects) {
            if (osmPrimitive.keys == null) continue;
            osmPrimitive.modified = true;
            osmPrimitive.put(this.newKey, (String)osmPrimitive.keys.remove(this.key));
        }
        return true;
    }

    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.objects);
    }

    public MutableTreeNode description() {
        Object object;
        String string = I18n.tr((String)"Replace \"{0}\" by \"{1}\" for", (Object[])new Object[]{this.key, this.newKey});
        if (this.objects.size() == 1) {
            object = new NameVisitor();
            this.objects.iterator().next().visit((Visitor)object);
            string = string + " " + I18n.tr((String)((NameVisitor)object).className) + " " + ((NameVisitor)object).name;
        } else {
            string = string + " " + this.objects.size() + " " + I18n.trn((String)"object", (String)"objects", (long)this.objects.size());
        }
        object = new DefaultMutableTreeNode(new JLabel(string, ImageProvider.get((String)"data", (String)"key"), 0));
        if (this.objects.size() == 1) {
            return object;
        }
        NameVisitor nameVisitor = new NameVisitor();
        for (OsmPrimitive osmPrimitive : this.objects) {
            osmPrimitive.visit((Visitor)nameVisitor);
            ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(nameVisitor.toLabel()));
        }
        return object;
    }
}

