/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.validator.ErrorTreePanel;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.ValidatorVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorDialog
extends ToggleDialog
implements ActionListener,
SelectionChangedListener {
    private OSMValidatorPlugin plugin;
    private static final long serialVersionUID = 2952292777351992696L;
    protected ErrorTreePanel tree;
    private SideButton fixButton;
    private SideButton ignoreButton;
    private SideButton selectButton;
    private JPopupMenu popupMenu;
    private TestError popupMenuError = null;
    private DefaultMutableTreeNode lastSelectedNode = null;

    public ValidatorDialog(OSMValidatorPlugin oSMValidatorPlugin) {
        super(I18n.tr((String)"Validation errors"), "validator", I18n.tr((String)"Open the validation window."), Shortcut.registerShortcut((String)"subwindow:validator", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Validation errors")}), (int)86, (int)4, (int)1), 150);
        this.plugin = oSMValidatorPlugin;
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18n.tr((String)"Zoom to problem"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorDialog.this.zoomToProblem();
            }
        });
        this.popupMenu.add(jMenuItem);
        this.tree = new ErrorTreePanel();
        this.tree.addMouseListener(new ClickWatch());
        this.tree.addTreeSelectionListener(new SelectionWatch());
        this.add(new JScrollPane(this.tree), "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        this.selectButton = new SideButton(I18n.marktr((String)"Select"), "select", "Validator", I18n.tr((String)"Set the selected elements on the map to the selected items in the list above."), (ActionListener)this);
        this.selectButton.setEnabled(false);
        jPanel.add((Component)this.selectButton);
        jPanel.add((Component)new SideButton(I18n.marktr((String)"Validate"), "refresh", "Validator", I18n.tr((String)"Validate either current selection or complete dataset."), (ActionListener)this));
        this.fixButton = new SideButton(I18n.marktr((String)"Fix"), "fix", "Validator", I18n.tr((String)"Fix the selected errors."), (ActionListener)this);
        this.fixButton.setEnabled(false);
        jPanel.add((Component)this.fixButton);
        if (Main.pref.getBoolean("validator.ignore", true)) {
            this.ignoreButton = new SideButton(I18n.marktr((String)"Ignore"), "delete", "Validator", I18n.tr((String)"Ignore the selected errors next time."), (ActionListener)this);
            this.ignoreButton.setEnabled(false);
            jPanel.add((Component)this.ignoreButton);
        } else {
            this.ignoreButton = null;
        }
        this.add(jPanel, "South");
        DataSet.selListeners.add(this);
    }

    public void setVisible(boolean bl) {
        if (this.tree != null) {
            this.tree.setVisible(bl);
        }
        if (this.action != null && this.action.button != null) {
            this.action.button.setSelected(bl);
        }
        super.setVisible(bl);
        Main.map.repaint();
    }

    private void fixErrors(ActionEvent actionEvent) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> hashSet = new HashSet<DefaultMutableTreeNode>();
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null) continue;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                TestError testError;
                Command command;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (hashSet.contains(defaultMutableTreeNode2)) continue;
                hashSet.add(defaultMutableTreeNode2);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof TestError) || (command = (testError = (TestError)object).getFix()) == null) continue;
                Main.main.undoRedo.add(command);
                testError.setIgnored(true);
            }
        }
        Main.map.repaint();
        this.tree.resetErrors();
        DataSet.fireSelectionChanged((Collection)Main.ds.getSelected());
    }

    private void ignoreErrors(ActionEvent actionEvent) {
        int n = -1;
        boolean bl = false;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (TreePath treePath : treePathArray) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null) continue;
            Object object6 = defaultMutableTreeNode.getUserObject();
            if (!(object6 instanceof TestError)) {
                object5 = new HashSet();
                if (n == -1) {
                    object4 = new String[]{I18n.tr((String)"Whole group"), I18n.tr((String)"Single elements"), I18n.tr((String)"Nothing")};
                    n = JOptionPane.showOptionDialog(Main.parent, I18n.tr((String)"Ignore whole group or individual elements?"), I18n.tr((String)"Ignoring elements"), 1, 2, ImageProvider.get((String)"dialogs", (String)"delete"), object4, object4[1]);
                }
                if (n == 0) {
                    object4 = defaultMutableTreeNode.breadthFirstEnumeration();
                    while (object4.hasMoreElements()) {
                        object3 = (DefaultMutableTreeNode)object4.nextElement();
                        if (hashSet.contains(object3)) continue;
                        hashSet.add(object3);
                        object2 = ((DefaultMutableTreeNode)object3).getUserObject();
                        if (!(object2 instanceof TestError)) continue;
                        object = (TestError)object2;
                        ((TestError)object).setIgnored(true);
                        bl = true;
                        object5.add(defaultMutableTreeNode.getDepth() == 1 ? ((TestError)object).getIgnoreSubGroup() : ((TestError)object).getIgnoreGroup());
                    }
                    object3 = object5.iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        this.plugin.ignoredErrors.add((String)object2);
                    }
                    continue;
                }
                if (n == 2) continue;
            }
            object5 = defaultMutableTreeNode.breadthFirstEnumeration();
            while (object5.hasMoreElements()) {
                object4 = (DefaultMutableTreeNode)object5.nextElement();
                if (hashSet.contains(object4)) continue;
                hashSet.add(object4);
                object3 = object4.getUserObject();
                if (!(object3 instanceof TestError)) continue;
                object2 = (TestError)object3;
                object = ((TestError)object2).getIgnoreState();
                if (object != null) {
                    this.plugin.ignoredErrors.add((String)object);
                }
                bl = true;
                ((TestError)object2).setIgnored(true);
            }
        }
        if (bl) {
            this.tree.resetErrors();
            this.plugin.saveIgnoredErrors();
            Main.map.repaint();
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        this.popupMenuError = null;
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        if (!(defaultMutableTreeNode.getUserObject() instanceof TestError)) {
            return;
        }
        this.popupMenuError = (TestError)defaultMutableTreeNode.getUserObject();
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void zoomToProblem() {
        if (this.popupMenuError == null) {
            return;
        }
        ValidatorBoundingXYVisitor validatorBoundingXYVisitor = new ValidatorBoundingXYVisitor();
        this.popupMenuError.visitHighlighted(validatorBoundingXYVisitor);
        if (validatorBoundingXYVisitor.min == null || validatorBoundingXYVisitor.max == null) {
            return;
        }
        validatorBoundingXYVisitor.enlargeBoundingBox();
        Main.map.mapView.recalculateCenterScale((BoundingXYVisitor)validatorBoundingXYVisitor);
    }

    private void setSelectedItems() {
        if (this.tree == null) {
            return;
        }
        HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(40);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof TestError)) continue;
                TestError testError = (TestError)object;
                hashSet.addAll(testError.getPrimitives());
            }
        }
        Main.ds.setSelected(hashSet);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Select")) {
            this.setSelectedItems();
        } else if (string.equals("Validate")) {
            this.plugin.validateAction.actionPerformed(actionEvent);
        } else if (string.equals("Fix")) {
            this.fixErrors(actionEvent);
        } else if (string.equals("Ignore")) {
            this.ignoreErrors(actionEvent);
        }
    }

    private boolean setSelection(Collection<OsmPrimitive> collection, boolean bl) {
        TestError testError;
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Enumeration<TreeNode> enumeration;
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(defaultMutableTreeNode2)) {
            enumeration = this.lastSelectedNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof TestError)) continue;
                testError = (TestError)object;
                testError.setSelected(false);
            }
        }
        this.lastSelectedNode = defaultMutableTreeNode2;
        if (defaultMutableTreeNode2 == null) {
            return bl2;
        }
        enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof TestError)) continue;
            testError = (TestError)object;
            testError.setSelected(true);
            boolean bl3 = bl2 = bl2 || testError.isFixable();
            if (!bl) continue;
            collection.addAll(testError.getPrimitives());
        }
        this.selectButton.setEnabled(true);
        if (this.ignoreButton != null) {
            this.ignoreButton.setEnabled(true);
        }
        return bl2;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (!Main.pref.getBoolean("validator.selectionFilter", false)) {
            return;
        }
        if (collection == null || collection.size() == 0) {
            this.tree.setFilter(null);
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        this.tree.setFilter(hashSet);
    }

    public static class ValidatorBoundingXYVisitor
    extends BoundingXYVisitor
    implements ValidatorVisitor {
        public void visit(OsmPrimitive osmPrimitive) {
            if (!osmPrimitive.deleted && !osmPrimitive.incomplete) {
                osmPrimitive.visit((Visitor)this);
            }
        }

        public void visit(WaySegment waySegment) {
            if (waySegment.lowerIndex < 0 || waySegment.lowerIndex + 1 >= waySegment.way.nodes.size()) {
                return;
            }
            this.visit((Node)waySegment.way.nodes.get(waySegment.lowerIndex));
            this.visit((Node)waySegment.way.nodes.get(waySegment.lowerIndex + 1));
        }
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            if (treeSelectionEvent.getSource() instanceof JScrollPane) {
                System.out.println(treeSelectionEvent.getSource());
                return;
            }
            boolean bl = ValidatorDialog.this.setSelection(null, false);
            ValidatorDialog.this.fixButton.setEnabled(bl);
            Main.map.repaint();
        }
    }

    public class ClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            boolean bl = mouseEvent.getClickCount() > 1;
            HashSet hashSet = bl ? new HashSet(40) : null;
            boolean bl2 = ValidatorDialog.this.setSelection(hashSet, bl);
            ValidatorDialog.this.fixButton.setEnabled(bl2);
            if (bl) {
                Main.ds.setSelected(hashSet);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ValidatorDialog.this.showPopupMenu(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ValidatorDialog.this.showPopupMenu(mouseEvent);
        }
    }
}

