/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.ErrorTreePanel;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.AgregatePrimitivesVisitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateUploadHook
implements UploadAction.UploadHook {
    private static final long serialVersionUID = -2304521273582574603L;
    private OSMValidatorPlugin plugin;

    public ValidateUploadHook(OSMValidatorPlugin oSMValidatorPlugin) {
        this.plugin = oSMValidatorPlugin;
    }

    public boolean checkUpload(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        Collection<Test> collection4 = OSMValidatorPlugin.getEnabledTests(true);
        if (collection4.isEmpty()) {
            return true;
        }
        AgregatePrimitivesVisitor agregatePrimitivesVisitor = new AgregatePrimitivesVisitor();
        agregatePrimitivesVisitor.visit(collection);
        Collection<OsmPrimitive> collection5 = agregatePrimitivesVisitor.visit(collection2);
        ArrayList<TestError> arrayList = new ArrayList<TestError>(30);
        for (Test object : collection4) {
            object.setBeforeUpload(true);
            object.setPartialSelection(true);
            object.startTest();
            object.visit(collection5);
            object.endTest();
            arrayList.addAll(object.getErrors());
        }
        collection4 = null;
        if (arrayList == null || arrayList.isEmpty()) {
            return true;
        }
        if (Main.pref.getBoolean("validator.ignore", true)) {
            int n = 0;
            for (TestError testError : arrayList) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(testError.getIgnoreState());
                arrayList2.add(testError.getIgnoreGroup());
                arrayList2.add(testError.getIgnoreSubGroup());
                for (String string : arrayList2) {
                    if (string == null || !this.plugin.ignoredErrors.contains(string)) continue;
                    testError.setIgnored(true);
                }
                if (testError.getIgnored().booleanValue()) continue;
                ++n;
            }
            if (n == 0) {
                return true;
            }
        }
        return this.displayErrorScreen(arrayList);
    }

    private boolean displayErrorScreen(List<TestError> list) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ErrorTreePanel errorTreePanel = new ErrorTreePanel(list);
        errorTreePanel.expandAll();
        jPanel.add((Component)new JScrollPane(errorTreePanel), GBC.eol());
        int n = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr((String)"Data with errors. Upload anyway?"), 0);
        if (n == 1) {
            this.plugin.validationDialog.tree.setErrors(list);
            this.plugin.validationDialog.setVisible(true);
            DataSet.fireSelectionChanged((Collection)Main.ds.getSelected());
        }
        return n == 0;
    }
}

