/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.AgregatePrimitivesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ValidateAction
extends JosmAction {
    private OSMValidatorPlugin plugin;
    private static final long serialVersionUID = -2304521273582574603L;
    private Collection<OsmPrimitive> lastSelection;

    public ValidateAction(OSMValidatorPlugin oSMValidatorPlugin) {
        super(I18n.tr((String)"Validation"), "validator", I18n.tr((String)"Performs the data validation"), Shortcut.registerShortcut((String)"tools:validate", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Validation")}), (int)86, (int)3, (int)1), true);
        this.plugin = oSMValidatorPlugin;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doValidate(actionEvent, true);
    }

    public void doValidate(ActionEvent actionEvent, boolean bl) {
        Object object;
        Collection<Object> collection;
        if (this.plugin.validateAction == null || Main.map == null || !Main.map.isVisible()) {
            return;
        }
        OSMValidatorPlugin.plugin.initializeErrorLayer();
        Collection<Test> collection2 = OSMValidatorPlugin.getEnabledTests(false);
        if (collection2.isEmpty()) {
            return;
        }
        if (bl) {
            collection = Main.ds.getSelected();
            if (collection.isEmpty()) {
                collection = Main.ds.allNonDeletedPrimitives();
                this.lastSelection = null;
            } else {
                object = new AgregatePrimitivesVisitor();
                collection = ((AgregatePrimitivesVisitor)object).visit(collection);
                this.lastSelection = collection;
            }
        } else {
            collection = this.lastSelection == null ? Main.ds.allNonDeletedPrimitives() : this.lastSelection;
        }
        object = new ArrayList(200);
        for (Test object2 : collection2) {
            object2.setPartialSelection(this.lastSelection != null);
            object2.startTest();
            object2.visit(collection);
            object2.endTest();
            object.addAll(object2.getErrors());
        }
        collection2 = null;
        if (Main.pref.getBoolean("validator.ignore", true)) {
            Iterator<Test> iterator = object.iterator();
            while (iterator.hasNext()) {
                TestError testError = (TestError)((Object)iterator.next());
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(testError.getIgnoreState());
                arrayList.add(testError.getIgnoreGroup());
                arrayList.add(testError.getIgnoreSubGroup());
                for (String string : arrayList) {
                    if (string == null || !this.plugin.ignoredErrors.contains(string)) continue;
                    testError.setIgnored(true);
                }
            }
        }
        this.plugin.validationDialog.tree.setErrors((List<TestError>)object);
        this.plugin.validationDialog.setVisible(true);
        DataSet.fireSelectionChanged((Collection)Main.ds.getSelected());
    }
}

