/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.GBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test
implements Visitor {
    protected String name;
    protected String description;
    protected boolean enabled = true;
    protected JCheckBox checkEnabled;
    protected JCheckBox checkBeforeUpload;
    protected boolean testBeforeUpload = true;
    protected boolean isBeforeUpload;
    protected List<TestError> errors = new ArrayList<TestError>(30);
    protected boolean partialSelection;

    public Test(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    public Test(String string) {
        this.name = string;
    }

    public static void initialize(OSMValidatorPlugin oSMValidatorPlugin) throws Exception {
    }

    public void startTest() {
        this.errors = new ArrayList<TestError>(30);
    }

    public void setPartialSelection(boolean bl) {
        this.partialSelection = bl;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public void endTest() {
    }

    public void visit(Collection<OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.deleted || osmPrimitive.incomplete) continue;
            osmPrimitive.visit((Visitor)this);
        }
    }

    public void visit(Node node) {
    }

    public void visit(Way way) {
    }

    public void visit(Relation relation) {
    }

    public void addGui(JPanel jPanel) {
        this.checkEnabled = new JCheckBox(this.name, this.enabled);
        this.checkEnabled.setToolTipText(this.description);
        jPanel.add((Component)this.checkEnabled, GBC.std());
        GBC gBC = GBC.eol();
        gBC.anchor = 13;
        this.checkBeforeUpload = new JCheckBox();
        this.checkBeforeUpload.setSelected(this.testBeforeUpload);
        jPanel.add((Component)this.checkBeforeUpload, gBC);
    }

    public boolean ok() {
        this.enabled = this.checkEnabled.isSelected();
        this.testBeforeUpload = this.checkBeforeUpload.isSelected();
        return false;
    }

    public Command fixError(TestError testError) {
        return null;
    }

    public boolean isFixable(TestError testError) {
        return false;
    }

    public boolean testBeforeUpload() {
        return this.testBeforeUpload;
    }

    public void setBeforeUpload(boolean bl) {
        this.isBeforeUpload = bl;
    }
}

