/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PreferenceEditor
implements PreferenceSetting {
    private OSMValidatorPlugin plugin;
    public static final String PREFIX = "validator";
    public static final String PREF_DEBUG = "validator.debug";
    public static final String PREF_LAYER = "validator.layer";
    public static final String PREF_TESTS = "validator.tests";
    public static final String PREF_USE_IGNORE = "validator.ignore";
    public static final String PREF_TESTS_BEFORE_UPLOAD = "validator.testsBeforeUpload";
    public static final String PREF_FILTER_BY_SELECTION = "validator.selectionFilter";
    private JCheckBox prefUseIgnore;
    private JCheckBox prefUseLayer;
    private Collection<Test> allTests;

    public PreferenceEditor(OSMValidatorPlugin oSMValidatorPlugin) {
        this.plugin = oSMValidatorPlugin;
    }

    public void addGui(PreferenceDialog preferenceDialog) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.prefUseIgnore = new JCheckBox(I18n.tr((String)"Use ignore list."), Main.pref.getBoolean(PREF_USE_IGNORE, true));
        this.prefUseIgnore.setToolTipText(I18n.tr((String)"Use the ignore list to suppress warnings."));
        jPanel.add((Component)this.prefUseIgnore, GBC.eol());
        this.prefUseLayer = new JCheckBox(I18n.tr((String)"Use error layer."), Main.pref.getBoolean(PREF_LAYER, true));
        this.prefUseLayer.setToolTipText(I18n.tr((String)"Use the error layer to display problematic elements."));
        jPanel.add((Component)this.prefUseLayer, GBC.eol());
        GBC gBC = GBC.eol().insets(-5, 0, 0, 0);
        gBC.anchor = 13;
        jPanel.add((Component)new JLabel(I18n.tr((String)"On demand")), GBC.std());
        jPanel.add((Component)new JLabel(I18n.tr((String)"On upload")), gBC);
        this.allTests = OSMValidatorPlugin.getTests();
        for (Test object2 : this.allTests) {
            object2.addGui(jPanel);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setBorder(null);
        String string = I18n.tr((String)"An OSM data validator that checks for common errors made by users and editor programs.");
        JPanel jPanel2 = preferenceDialog.createPreferenceTab(PREFIX, I18n.tr((String)"Data validator"), string);
        jPanel2.add((Component)jScrollPane, GBC.eol().fill(1));
        jPanel2.add(GBC.glue((int)0, (int)10), gBC);
    }

    public boolean ok() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Boolean bl = false;
        for (Test test : this.allTests) {
            if (test.ok()) {
                bl = false;
            }
            String string = test.getClass().getSimpleName();
            stringBuilder.append(',').append(string).append('=').append(test.enabled);
            stringBuilder2.append(',').append(string).append('=').append(test.testBeforeUpload);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder = stringBuilder.deleteCharAt(0);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder2 = stringBuilder2.deleteCharAt(0);
        }
        this.plugin.initializeTests(this.allTests);
        Main.pref.put(PREF_TESTS, stringBuilder.toString());
        Main.pref.put(PREF_TESTS_BEFORE_UPLOAD, stringBuilder2.toString());
        Main.pref.put(PREF_USE_IGNORE, this.prefUseIgnore.isSelected());
        Main.pref.put(PREF_LAYER, this.prefUseLayer.isSelected());
        return false;
    }
}

