/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.projection.Epsg4326;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.validator.ErrorLayer;
import org.openstreetmap.josm.plugins.validator.GridLayer;
import org.openstreetmap.josm.plugins.validator.PreferenceEditor;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.ValidateAction;
import org.openstreetmap.josm.plugins.validator.ValidateUploadHook;
import org.openstreetmap.josm.plugins.validator.ValidatorDialog;
import org.openstreetmap.josm.plugins.validator.tests.Coastlines;
import org.openstreetmap.josm.plugins.validator.tests.CrossingWays;
import org.openstreetmap.josm.plugins.validator.tests.DuplicateNode;
import org.openstreetmap.josm.plugins.validator.tests.DuplicatedWayNodes;
import org.openstreetmap.josm.plugins.validator.tests.NodesWithSameName;
import org.openstreetmap.josm.plugins.validator.tests.OverlappingWays;
import org.openstreetmap.josm.plugins.validator.tests.SelfIntersectingWay;
import org.openstreetmap.josm.plugins.validator.tests.SimilarNamedWays;
import org.openstreetmap.josm.plugins.validator.tests.TagChecker;
import org.openstreetmap.josm.plugins.validator.tests.UnclosedWays;
import org.openstreetmap.josm.plugins.validator.tests.UnconnectedWays;
import org.openstreetmap.josm.plugins.validator.tests.UntaggedNode;
import org.openstreetmap.josm.plugins.validator.tests.UntaggedWay;
import org.openstreetmap.josm.plugins.validator.tests.WronglyOrderedWays;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSMValidatorPlugin
extends Plugin
implements Layer.LayerChangeListener {
    protected static OSMValidatorPlugin plugin;
    protected static ErrorLayer errorLayer;
    ValidateAction validateAction = new ValidateAction(this);
    ValidatorDialog validationDialog;
    Map<Layer, List<TestError>> layerErrors = new HashMap<Layer, List<TestError>>();
    public static double griddetail;
    public Collection<String> ignoredErrors = new TreeSet<String>();
    public static Class<Test>[] allAvailableTests;

    public OSMValidatorPlugin() {
        plugin = this;
        this.checkPluginDir();
        this.initializeGridDetail();
        this.initializeTests(OSMValidatorPlugin.getTests());
        this.loadIgnoredErrors();
    }

    private void checkPluginDir() {
        try {
            File file = new File(Util.getPluginDir());
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadIgnoredErrors() {
        this.ignoredErrors.clear();
        if (Main.pref.getBoolean("validator.ignore", true)) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(Util.getPluginDir() + "ignorederrors"));
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.ignoredErrors.add(string);
                    string = bufferedReader.readLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void saveIgnoredErrors() {
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(Util.getPluginDir() + "ignorederrors"), false);
            for (String string : this.ignoredErrors) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new PreferenceEditor(this);
    }

    public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
        if (mapFrame2 != null) {
            this.validationDialog = new ValidatorDialog(this);
            mapFrame2.addToggleDialog((ToggleDialog)this.validationDialog);
            this.initializeErrorLayer();
            if (Main.pref.hasKey("validator.debug.grid")) {
                Main.main.addLayer((Layer)new GridLayer(I18n.tr((String)"Grid")));
            }
            Layer.listeners.add(this);
        } else {
            Layer.listeners.remove((Object)this);
        }
        LinkedList linkedList = ((UploadAction)Main.main.menu.upload).uploadHooks;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof ValidateUploadHook)) continue;
            if (mapFrame2 != null) break;
            iterator.remove();
            break;
        }
        if (mapFrame2 != null) {
            linkedList.add(0, new ValidateUploadHook(this));
        }
    }

    public void initializeErrorLayer() {
        if (!Main.pref.getBoolean("validator.layer", true)) {
            return;
        }
        if (errorLayer == null) {
            errorLayer = new ErrorLayer(this);
            Main.main.addLayer((Layer)errorLayer);
        }
    }

    public static Map<String, Test> getAllTestsMap() {
        HashMap<String, Test> hashMap = new HashMap<String, Test>();
        for (Class<Test> clazz : OSMValidatorPlugin.getAllAvailableTests()) {
            try {
                Test test = clazz.newInstance();
                hashMap.put(clazz.getSimpleName(), test);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        OSMValidatorPlugin.applyPrefs(hashMap, false);
        OSMValidatorPlugin.applyPrefs(hashMap, true);
        return hashMap;
    }

    private static void applyPrefs(Map<String, Test> map, boolean bl) {
        Pattern pattern = Pattern.compile("(\\w+)=(true|false),?");
        Matcher matcher = pattern.matcher(Main.pref.get(bl ? "validator.testsBeforeUpload" : "validator.tests"));
        int n = 0;
        while (matcher.find(n)) {
            String string = matcher.group(1);
            Test test = map.get(string);
            if (test != null) {
                boolean bl2 = Boolean.valueOf(matcher.group(2));
                if (bl) {
                    test.testBeforeUpload = bl2;
                } else {
                    test.enabled = bl2;
                }
            }
            n = matcher.end();
        }
    }

    public static Collection<Test> getTests() {
        return OSMValidatorPlugin.getAllTestsMap().values();
    }

    public static Collection<Test> getEnabledTests(boolean bl) {
        Collection<Test> collection = OSMValidatorPlugin.getTests();
        for (Test test : new ArrayList<Test>(collection)) {
            if (bl ? test.testBeforeUpload : test.enabled) continue;
            collection.remove(test);
        }
        return collection;
    }

    public static Class<Test>[] getAllAvailableTests() {
        return allAvailableTests;
    }

    public void initializeGridDetail() {
        if (Main.proj.toString().equals(new Epsg4326().toString())) {
            griddetail = 10000.0;
        } else if (Main.proj.toString().equals(new Mercator().toString())) {
            griddetail = 100000.0;
        } else if (Main.proj.toString().equals(new Lambert().toString())) {
            griddetail = 0.1;
        }
    }

    public void initializeTests(Collection<Test> collection) {
        for (Test test : collection) {
            try {
                if (!test.enabled) continue;
                test.getClass().getMethod("initialize", OSMValidatorPlugin.class).invoke(null, new Object[]{this});
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getCause().printStackTrace();
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Error initializing test {0}:\n {1}", (Object[])new Object[]{test.getClass().getSimpleName(), invocationTargetException.getCause().getMessage()}));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Error initializing test {0}:\n {1}", (Object[])new Object[]{test.getClass().getSimpleName(), exception}));
            }
        }
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
        if (layer2 instanceof OsmDataLayer) {
            List<TestError> list = this.layerErrors.get(layer2);
            this.validationDialog.tree.setErrorList(list);
            Main.map.repaint();
        }
    }

    public void layerAdded(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            this.layerErrors.put(layer, new ArrayList());
        }
    }

    public void layerRemoved(Layer layer) {
        this.layerErrors.remove(layer);
    }

    static {
        errorLayer = null;
        allAvailableTests = new Class[]{DuplicateNode.class, OverlappingWays.class, UntaggedNode.class, UntaggedWay.class, SelfIntersectingWay.class, DuplicatedWayNodes.class, CrossingWays.class, SimilarNamedWays.class, NodesWithSameName.class, Coastlines.class, WronglyOrderedWays.class, UnclosedWays.class, TagChecker.class, UnconnectedWays.class};
    }
}

