/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.ImageProvider;

public class GridLayer
extends Layer {
    public GridLayer(String string) {
        super(string);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"validator");
    }

    public void paint(Graphics graphics, MapView mapView) {
        Point point;
        double d;
        long l;
        if (!Main.pref.hasKey("validator.debug.grid")) {
            return;
        }
        int n = Integer.parseInt(Main.pref.get("validator.debug.grid"));
        int n2 = mapView.getWidth();
        int n3 = mapView.getHeight();
        EastNorth eastNorth = mapView.getEastNorth(0, 0);
        EastNorth eastNorth2 = mapView.getEastNorth(n2, n3);
        if (eastNorth2.east() * (double)n > 50.0) {
            return;
        }
        graphics.setColor(Color.RED.darker().darker());
        HighlightCellVisitor highlightCellVisitor = new HighlightCellVisitor(graphics, mapView, n);
        for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
            osmPrimitive.visit((Visitor)highlightCellVisitor);
        }
        long l2 = (long)Math.floor(eastNorth.east() * (double)n);
        long l3 = (long)Math.floor(eastNorth2.east() * (double)n);
        long l4 = (long)Math.floor(eastNorth.north() * (double)n) + 1L;
        long l5 = (long)Math.floor(eastNorth2.north() * (double)n) + 1L;
        if (l2 > l3) {
            l = l2;
            l2 = l3;
            l3 = l;
        }
        if (l4 > l5) {
            l = l4;
            l4 = l5;
            l5 = l;
        }
        graphics.setColor(Color.RED.brighter().brighter());
        for (d = (double)l2; d <= (double)l3; d += 1.0) {
            point = mapView.getPoint(new EastNorth(d / (double)n, 0.0));
            graphics.drawLine(point.x, 0, point.x, n3);
        }
        for (d = (double)l4; d <= (double)l5; d += 1.0) {
            point = mapView.getPoint(new EastNorth(0.0, d / (double)n));
            graphics.drawLine(0, point.y, n2, point.y);
        }
    }

    public String getToolTipText() {
        return null;
    }

    public void mergeFrom(Layer layer) {
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(null, (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public void destroy() {
    }

    class HighlightCellVisitor
    implements Visitor {
        private final MapView mv;
        private final Graphics g;
        private final int gridDetail;
        private int cellWidth;

        public HighlightCellVisitor(Graphics graphics, MapView mapView, int n) {
            this.g = graphics;
            this.mv = mapView;
            this.gridDetail = n;
            Point point = mapView.getPoint(new EastNorth(0.0, 0.0));
            Point point2 = mapView.getPoint(new EastNorth(1.0 / (double)n, 1.0 / (double)n));
            this.cellWidth = Math.abs(point2.x - point.x);
        }

        public void visit(Node node) {
            double d = node.eastNorth.east() * (double)this.gridDetail;
            double d2 = node.eastNorth.north() * (double)this.gridDetail + 1.0;
            this.drawCell(Math.floor(d), Math.floor(d2));
        }

        public void visit(Way way) {
            Node node = null;
            for (Node node2 : way.nodes) {
                if (node == null) {
                    node = node2;
                    continue;
                }
                for (Point2D point2D : Util.getSegmentCells(node, node2, this.gridDetail)) {
                    this.drawCell(point2D.getX(), point2D.getY());
                }
                node = node2;
            }
        }

        public void visit(Relation relation) {
        }

        protected void drawCell(double d, double d2) {
            Point point = this.mv.getPoint(new EastNorth(d / (double)this.gridDetail, d2 / (double)this.gridDetail));
            this.g.fillRect(point.x, point.y, this.cellWidth, this.cellWidth);
        }
    }
}

