/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.ErrorTreeRenderer;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.plugins.validator.util.MultipleNameVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorTreePanel
extends JTree {
    private static final long serialVersionUID = 2952292777351992696L;
    protected DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private List<TestError> errors;
    private Set<OsmPrimitive> filter = null;

    public ErrorTreePanel(List<TestError> list) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(this.treeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRow(0);
        this.setVisibleRowCount(8);
        this.setCellRenderer(new ErrorTreeRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setErrorList(list);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof TestError) {
                TestError testError = (TestError)object;
                MultipleNameVisitor multipleNameVisitor = new MultipleNameVisitor();
                multipleNameVisitor.visit(testError.getPrimitives());
                string = "<html>" + multipleNameVisitor.getText() + "<br>" + testError.getMessage();
                String string2 = testError.getDescription();
                if (string2 != null) {
                    string = string + "<br>" + string2;
                }
                string = string + "</html>";
            } else {
                string = defaultMutableTreeNode.toString();
            }
        }
        return string;
    }

    public ErrorTreePanel() {
        this((List<TestError>)null);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.buildTree();
        } else {
            this.treeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(bl);
    }

    public void buildTree() {
        Object object;
        Cloneable cloneable;
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (this.errors == null || this.errors.isEmpty()) {
            this.treeModel.setRoot(defaultMutableTreeNode);
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(new TreePath(this.getRoot()));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                cloneable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent();
                object = ((DefaultMutableTreeNode)cloneable).getUserObject();
                if (object instanceof Severity) {
                    hashSet.add(object);
                    continue;
                }
                if (!(object instanceof String)) continue;
                String string = (String)object;
                string = string.substring(0, string.lastIndexOf(" ("));
                hashSet.add(string);
            }
        }
        serializable = new HashMap();
        cloneable = new HashMap();
        for (Object object2 : Severity.values()) {
            serializable.put(object2, new Bag(20));
            cloneable.put(object2, new HashMap());
        }
        for (TestError testError : this.errors) {
            Object object2;
            if (testError.getIgnored().booleanValue()) continue;
            Severity severity = testError.getSeverity();
            object2 = testError.getDescription();
            String object3 = testError.getMessage();
            if (this.filter != null) {
                boolean bag = false;
                for (OsmPrimitive osmPrimitive : testError.getPrimitives()) {
                    if (!this.filter.contains(osmPrimitive)) continue;
                    bag = true;
                    break;
                }
                if (!bag) continue;
            }
            if (object2 != null) {
                Bag<Severity, TestError> bag = (Bag<Severity, TestError>)((HashMap)cloneable.get((Object)severity)).get(object3);
                if (bag == null) {
                    bag = new Bag<Severity, TestError>(20);
                    ((HashMap)cloneable.get((Object)severity)).put(object3, bag);
                }
                bag.add((Severity)((Object)object2), testError);
                continue;
            }
            ((Bag)serializable.get((Object)severity)).add(object3, testError);
        }
        object = new ArrayList();
        for (Severity severity : Severity.values()) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Bag bag = (Bag)serializable.get((Object)severity);
            Map map = (Map)cloneable.get((Object)severity);
            if (bag.isEmpty() && map.isEmpty()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)severity);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (hashSet.contains((Object)severity)) {
                object.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2}));
            }
            for (Map.Entry entry : bag.entrySet()) {
                object6 = (List)entry.getValue();
                object5 = (String)entry.getKey() + " (" + object6.size() + ")";
                object4 = new DefaultMutableTreeNode(object5);
                defaultMutableTreeNode2.add((MutableTreeNode)object4);
                if (hashSet.contains(entry.getKey())) {
                    object.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, object4}));
                }
                Iterator iterator = object6.iterator();
                while (iterator.hasNext()) {
                    object3 = (TestError)iterator.next();
                    object2 = new DefaultMutableTreeNode(object3);
                    ((DefaultMutableTreeNode)object4).add((MutableTreeNode)object2);
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                object6 = (Bag)entry.getValue();
                object5 = null;
                if (((HashMap)object6).size() > 1) {
                    object4 = (String)entry.getKey() + " (" + ((HashMap)object6).size() + ")";
                    object5 = new DefaultMutableTreeNode(object4);
                    defaultMutableTreeNode2.add((MutableTreeNode)object5);
                    if (hashSet.contains(entry.getKey())) {
                        object.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, object5}));
                    }
                }
                for (Map.Entry entry2 : ((HashMap)object6).entrySet()) {
                    object3 = (List)entry2.getValue();
                    object2 = object5 != null ? (String)entry2.getKey() + " (" + object3.size() + ")" : (String)entry2.getKey() + " - " + (String)entry.getKey() + " (" + object3.size() + ")";
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(object2);
                    if (object5 != null) {
                        ((DefaultMutableTreeNode)object5).add(defaultMutableTreeNode3);
                    } else {
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    }
                    if (hashSet.contains(entry2.getKey())) {
                        if (object5 != null) {
                            object.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, object5, defaultMutableTreeNode3}));
                        } else {
                            object.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode3}));
                        }
                    }
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        TestError testError = (TestError)iterator.next();
                        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(testError);
                        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                    }
                }
            }
        }
        this.treeModel.setRoot(defaultMutableTreeNode);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            TreePath treePath = (TreePath)iterator.next();
            this.expandPath(treePath);
        }
    }

    public void setErrorList(List<TestError> list) {
        this.errors = list;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void setErrors(List<TestError> list) {
        if (this.errors == null) {
            return;
        }
        this.errors.clear();
        for (TestError testError : list) {
            if (testError.getIgnored().booleanValue()) continue;
            this.errors.add(testError);
        }
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public List<TestError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public Set<OsmPrimitive> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<OsmPrimitive> set) {
        this.filter = set != null && set.size() == 0 ? null : set;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void resetErrors() {
        ArrayList<TestError> arrayList = new ArrayList<TestError>(this.errors);
        this.setErrors(arrayList);
    }

    public void expandAll() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getRoot();
        int n = 0;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            this.expandRow(n++);
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.treeModel.getRoot();
    }
}

