/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ErrorLayer
extends Layer
implements Layer.LayerChangeListener {
    private OSMValidatorPlugin plugin;

    public ErrorLayer(OSMValidatorPlugin oSMValidatorPlugin) {
        super(I18n.tr((String)"Validation errors"));
        this.plugin = oSMValidatorPlugin;
        Layer.listeners.add(this);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"validator");
    }

    public void paint(Graphics graphics, MapView mapView) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.plugin.validationDialog.tree.getRoot();
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild(); defaultMutableTreeNode2 != null; defaultMutableTreeNode2 = defaultMutableTreeNode2.getPreviousSibling()) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                Object object = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
                if (!(object instanceof TestError)) continue;
                ((TestError)object).paint(graphics, mapView);
            }
        }
    }

    public String getToolTipText() {
        Bag<Severity, TestError> bag = new Bag<Severity, TestError>();
        List<TestError> list = this.plugin.validationDialog.tree.getErrors();
        for (TestError severityArray : list) {
            bag.add(severityArray.getSeverity(), severityArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Severity severity : Severity.values()) {
            if (!bag.containsKey((Object)severity)) continue;
            stringBuilder.append(I18n.tr((String)severity.toString())).append(": ").append(bag.get(severity).size()).append("<br>");
        }
        if (stringBuilder.length() == 0) {
            return "<html>" + I18n.tr((String)"No validation errors") + "</html>";
        }
        return "<html>" + I18n.tr((String)"Validation errors") + ":<br>" + stringBuilder + "</html>";
    }

    public void mergeFrom(Layer layer) {
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(null, (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public void destroy() {
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    public void layerAdded(Layer layer) {
    }

    public void layerRemoved(Layer layer) {
        if (layer == Main.map.mapView.editLayer) {
            Main.map.mapView.removeLayer((Layer)this);
        } else if (layer == this) {
            OSMValidatorPlugin.errorLayer = null;
        }
    }
}

