/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import livegps.LiveGpsLock;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;

public class AutoSaveEditLayerTimerTask
extends TimerTask {
    private File file;

    public AutoSaveEditLayerTimerTask(String filename) {
        this.file = new File(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Main.map == null || Main.map.mapView == null || Main.map.mapView.editLayer == null) {
            return;
        }
        OsmDataLayer layer = Main.map.mapView.editLayer;
        try {
            DataSet dataset = layer.data;
            File tmpFile = new File(this.file.getAbsoluteFile() + ".tmp");
            System.out.println("AutoSaving osm data to file " + this.file.getAbsolutePath());
            Class<LiveGpsLock> clazz = LiveGpsLock.class;
            synchronized (LiveGpsLock.class) {
                XmlWriter.output((OutputStream)new FileOutputStream(tmpFile), (XmlWriter.OsmWriterInterface)new OsmWriter.All(dataset, false));
                // ** MonitorExit[var4_5] (shouldn't be in output)
                tmpFile.renameTo(this.file);
                System.out.println("AutoSaving finished");
            }
        }
        catch (IOException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while exporting {0}: {1}", (Object[])new Object[]{this.file.getAbsoluteFile(), x.getMessage()}), I18n.tr((String)"Error"), 0);
        }
    }
}

