/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.colorscheme;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.ColorPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorSchemePreference
implements PreferenceSetting {
    private static final String PREF_KEY_SCHEMES_PREFIX = "colorschemes.";
    private static final String PREF_KEY_SCHEMES_NAMES = "colorschemes.names";
    public static final String PREF_KEY_COLOR_PREFIX = "color.";
    private JList schemesList;
    private DefaultListModel listModel;
    private List<String> colorKeys;
    private ColorPreference colorPreference;

    public void addGui(PreferenceDialog preferenceDialog) {
        Map map = Main.pref.getAllPrefix(PREF_KEY_COLOR_PREFIX);
        this.colorKeys = new ArrayList(map.keySet());
        Collections.sort(this.colorKeys);
        this.listModel = new DefaultListModel();
        this.schemesList = new JList(this.listModel);
        String string = Main.pref.get(PREF_KEY_SCHEMES_NAMES);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.listModel.addElement(string2);
        }
        JButton jButton = new JButton(I18n.tr((String)"Use"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorSchemePreference.this.schemesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select a scheme to use."));
                } else {
                    String string = (String)ColorSchemePreference.this.listModel.get(ColorSchemePreference.this.schemesList.getSelectedIndex());
                    ColorSchemePreference.this.getColorPreference().setColorModel(ColorSchemePreference.this.getColorMap(string));
                }
            }
        });
        JButton jButton2 = new JButton(I18n.tr((String)"Add"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Color Scheme"));
                if (string == null) {
                    return;
                }
                string = string.replaceAll("\\.", "_");
                ColorSchemePreference.this.setColorScheme(string, ColorSchemePreference.this.getColorPreference().getColorModel());
                ColorSchemePreference.this.listModel.addElement(string);
                ColorSchemePreference.this.saveSchemeNamesToPref();
            }
        });
        JButton jButton3 = new JButton(I18n.tr((String)"Delete"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorSchemePreference.this.schemesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the scheme to delete."));
                } else {
                    String string = (String)ColorSchemePreference.this.listModel.get(ColorSchemePreference.this.schemesList.getSelectedIndex());
                    ColorSchemePreference.this.removeColorSchemeFromPreferences(string);
                    ColorSchemePreference.this.listModel.remove(ColorSchemePreference.this.schemesList.getSelectedIndex());
                    ColorSchemePreference.this.saveSchemeNamesToPref();
                }
            }
        });
        this.schemesList.setVisibleRowCount(3);
        jButton.setToolTipText(I18n.tr((String)"Use the selected scheme from the list."));
        jButton2.setToolTipText(I18n.tr((String)"Use the current colors as a new color scheme."));
        jButton3.setToolTipText(I18n.tr((String)"Delete the selected scheme from the list."));
        preferenceDialog.map.add((Component)new JLabel(I18n.tr((String)"Color Schemes")), GBC.eol().insets(0, 5, 0, 0));
        preferenceDialog.map.add((Component)new JScrollPane(this.schemesList), GBC.eol().fill(1));
        JPanel jPanel = new JPanel(new GridBagLayout());
        preferenceDialog.map.add((Component)jPanel, GBC.eol().fill(2));
        jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        jPanel.add((Component)jButton, GBC.std().insets(0, 5, 5, 0));
        jPanel.add((Component)jButton2, GBC.std().insets(0, 5, 5, 0));
        jPanel.add((Component)jButton3, GBC.std().insets(0, 5, 5, 0));
    }

    public void saveSchemeNamesToPref() {
        if (this.schemesList.getModel().getSize() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.schemesList.getModel().getSize(); ++i) {
                stringBuilder.append(";" + this.schemesList.getModel().getElementAt(i));
            }
            Main.pref.put(PREF_KEY_SCHEMES_NAMES, stringBuilder.toString().substring(1));
        } else {
            Main.pref.put(PREF_KEY_SCHEMES_NAMES, null);
        }
    }

    public boolean ok() {
        return false;
    }

    public void removeColorSchemeFromPreferences(String string) {
        Map map = Main.pref.getAllPrefix(PREF_KEY_SCHEMES_PREFIX + string + ".");
        for (String string2 : map.keySet()) {
            Main.pref.put(string2, null);
        }
    }

    public void setColorScheme(String string, Map<String, String> map) {
        for (String string2 : map.keySet()) {
            String string3 = PREF_KEY_SCHEMES_PREFIX + string + "." + PREF_KEY_COLOR_PREFIX + string2;
            Main.pref.put(string3, map.get(string2));
        }
    }

    public Map<String, String> getColorMap(String string) {
        String string2 = PREF_KEY_SCHEMES_PREFIX + string + "." + PREF_KEY_COLOR_PREFIX;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : Main.pref.getAllPrefix(string2).keySet()) {
            String string4 = string3.substring(string2.length());
            hashMap.put(string4, Main.pref.get(string3));
        }
        return hashMap;
    }

    public ColorPreference getColorPreference() {
        if (this.colorPreference == null) {
            for (PreferenceSetting preferenceSetting : PreferenceDialog.settings) {
                if (!(preferenceSetting instanceof ColorPreference)) continue;
                this.colorPreference = (ColorPreference)preferenceSetting;
                break;
            }
        }
        return this.colorPreference;
    }
}

