/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import org.openstreetmap.josm.Main;

public class SlippyMapPreferences {
    public static final String PREFERENCE_PREFIX = "slippymap";
    public static final String PREFERENCE_TILE_URL = "slippymap.tile_url";
    public static final String PREFERENCE_AUTOZOOM = "slippymap.autozoom";
    public static final String PREFERENCE_AUTOLOADTILES = "slippymap.autoload_tiles";
    public static final String PREFERENCE_MIN_ZOOM_LVL = "slippymap.min_zoom_lvl";
    public static final String PREFERENCE_MAX_ZOOM_LVL = "slippymap.max_zoom_lvl";
    public static final String PREFERENCE_FADE_BACKGROUND = "slippymap.fade_background";
    public static final String PREFERENCE_DRAW_DEBUG = "slippymap.draw_debug";

    public static String getMapUrl() {
        String string = Main.pref.get(PREFERENCE_TILE_URL);
        if (string == null || "".equals(string)) {
            string = "http://tah.openstreetmap.org/Tiles/tile";
            Main.pref.put(PREFERENCE_TILE_URL, string);
        }
        return string;
    }

    public static void setMapUrl(String string) {
        Main.pref.put(PREFERENCE_TILE_URL, string);
    }

    public static boolean getAutozoom() {
        String string = Main.pref.get(PREFERENCE_AUTOZOOM);
        if (string == null || "".equals(string)) {
            string = "true";
            Main.pref.put(PREFERENCE_AUTOZOOM, string);
        }
        return Boolean.parseBoolean(string);
    }

    public static void setAutozoom(boolean bl) {
        Main.pref.put(PREFERENCE_AUTOZOOM, bl);
    }

    public static void setDrawDebug(boolean bl) {
        Main.pref.put(PREFERENCE_DRAW_DEBUG, bl);
    }

    public static boolean getDrawDebug() {
        String string = Main.pref.get(PREFERENCE_DRAW_DEBUG);
        if (string == null || "".equals(string)) {
            string = "false";
            Main.pref.put(PREFERENCE_DRAW_DEBUG, string);
        }
        return Boolean.parseBoolean(string);
    }

    public static boolean getAutoloadTiles() {
        String string = Main.pref.get(PREFERENCE_AUTOLOADTILES);
        if (string == null || "".equals(string)) {
            string = "true";
            Main.pref.put(PREFERENCE_AUTOLOADTILES, string);
        }
        return Boolean.parseBoolean(string);
    }

    public static void setFadeBackground(float f) {
        Main.pref.put(PREFERENCE_FADE_BACKGROUND, f + "");
    }

    public static float getFadeBackground() {
        float f;
        String string = Main.pref.get(PREFERENCE_FADE_BACKGROUND);
        if (string == null || "".equals(string)) {
            string = "0.0";
            Main.pref.put(PREFERENCE_FADE_BACKGROUND, string);
        }
        try {
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            SlippyMapPreferences.setFadeBackground(0.1f);
            System.out.println("Error while parsing setting fade background to float! returning 0.1, because of error:");
            exception.printStackTrace(System.out);
            return 0.1f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static void setAutoloadTiles(boolean bl) {
        Main.pref.put(PREFERENCE_AUTOLOADTILES, bl);
    }

    public static int getMaxZoomLvl() {
        int n;
        String string = Main.pref.get(PREFERENCE_MAX_ZOOM_LVL);
        if (string == null || "".equals(string)) {
            string = "17";
            Main.pref.put(PREFERENCE_MAX_ZOOM_LVL, string);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Problem while converting string to int. Converting value of prefetrences slippymap.max_zoom_lvl. Value=\"" + string + "\". Should be an integer. Error: " + exception.getMessage(), exception);
        }
        if (n > 30) {
            System.err.println("MaxZoomLvl shouldnt be more than 30! Setting to 30.");
            n = 30;
        }
        return n;
    }

    public static void setMaxZoomLvl(int n) {
        if (n > 30) {
            System.err.println("MaxZoomLvl shouldnt be more than 30! Setting to 30.");
            n = 30;
        }
        if (n < SlippyMapPreferences.getMinZoomLvl()) {
            System.err.println("maxZoomLvl shouldnt be more than minZoomLvl! Setting to minZoomLvl.");
            n = SlippyMapPreferences.getMinZoomLvl();
        }
        Main.pref.put(PREFERENCE_MAX_ZOOM_LVL, "" + n);
    }

    public static int getMinZoomLvl() {
        int n;
        String string = Main.pref.get(PREFERENCE_MIN_ZOOM_LVL);
        if (string == null || "".equals(string)) {
            string = "" + (SlippyMapPreferences.getMaxZoomLvl() - 4);
            Main.pref.put(PREFERENCE_MAX_ZOOM_LVL, string);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Problem while converting string to int. Converting value of prefetrences slippymap.min_zoom_lvl. Value=\"" + string + "\". Should be an integer. Error: " + exception.getMessage(), exception);
        }
        if (n < 2) {
            System.err.println("minZoomLvl shouldnt be lees than 2! Setting to 2.");
            n = 2;
        }
        return n;
    }

    public static void setMinZoomLvl(int n) {
        if (n < 2) {
            System.err.println("minZoomLvl shouldnt be lees than 2! Setting to 2.");
            n = 2;
        }
        if (n > SlippyMapPreferences.getMaxZoomLvl()) {
            System.err.println("minZoomLvl shouldnt be more than maxZoomLvl! Setting to maxZoomLvl.");
            n = SlippyMapPreferences.getMaxZoomLvl();
        }
        Main.pref.put(PREFERENCE_MIN_ZOOM_LVL, "" + n);
    }

    public static String[] getAllMapUrls() {
        String[] stringArray = new String[]{"http://tah.openstreetmap.org/Tiles/tile", "http://tah.openstreetmap.org/Tiles/maplint", "http://tile.openstreetmap.org", "http://hypercube.telascience.org/tiles/1.0.0/coastline", "http://www.freemap.sk/layers/allinone/?", "http://www.freemap.sk/layers/tiles/?"};
        return stringArray;
    }
}

