/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapPreferenceSetting
implements PreferenceSetting {
    private JComboBox tileSourceCombo;
    private JCheckBox autozoomActive = new JCheckBox(I18n.tr((String)"autozoom"));
    private JCheckBox autoloadTiles = new JCheckBox(I18n.tr((String)"autoload tiles"));
    private JSpinner maxZoomLvl = new JSpinner();
    private JSlider fadeBackground = new JSlider(0, 100);

    public void addGui(PreferenceDialog preferenceDialog) {
        JPanel jPanel = preferenceDialog.createPreferenceTab("slippymap.png", I18n.tr((String)"SlippyMap"), I18n.tr((String)"Settings for the SlippyMap plugin."));
        JPanel jPanel2 = new JPanel();
        String[] stringArray = SlippyMapPreferences.getAllMapUrls();
        this.tileSourceCombo = new JComboBox<String>(stringArray);
        this.tileSourceCombo.setEditable(true);
        String string = SlippyMapPreferences.getMapUrl();
        this.tileSourceCombo.setSelectedItem(string);
        jPanel2.add((Component)new JLabel(I18n.tr((String)"Tile Sources")), GBC.std());
        jPanel2.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        jPanel2.add((Component)this.tileSourceCombo, GBC.eol().fill(2));
        JPanel jPanel3 = new JPanel();
        jPanel3.add((Component)new JLabel(I18n.tr((String)"Auto zoom: ")), GBC.std());
        jPanel3.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        jPanel3.add((Component)this.autozoomActive, GBC.eol().fill(2));
        JPanel jPanel4 = new JPanel();
        jPanel4.add((Component)new JLabel(I18n.tr((String)"Autoload Tiles: ")), GBC.std());
        jPanel4.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        jPanel4.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        JPanel jPanel5 = new JPanel();
        jPanel5.add((Component)new JLabel(I18n.tr((String)"Max zoom lvl: ")), GBC.std());
        jPanel5.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        jPanel5.add((Component)this.maxZoomLvl, GBC.eol().fill(2));
        JPanel jPanel6 = new JPanel();
        jPanel6.add((Component)new JLabel(I18n.tr((String)"Fade background: ")), GBC.std());
        jPanel6.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        jPanel6.add((Component)this.fadeBackground, GBC.eol().fill(2));
        jPanel.add((Component)jPanel2, GBC.eol().fill(2));
        jPanel.add((Component)jPanel3, GBC.eol().fill(2));
        jPanel.add((Component)jPanel4, GBC.eol().fill(2));
        jPanel.add((Component)jPanel5, GBC.eol().fill(2));
        jPanel.add((Component)jPanel6, GBC.eol().fill(2));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.loadSettings();
    }

    private void loadSettings() {
        this.autozoomActive.setSelected(SlippyMapPreferences.getAutozoom());
        this.autoloadTiles.setSelected(SlippyMapPreferences.getAutoloadTiles());
        this.maxZoomLvl.setValue(SlippyMapPreferences.getMaxZoomLvl());
        this.fadeBackground.setValue(Math.round(SlippyMapPreferences.getFadeBackground() * 100.0f));
    }

    public boolean ok() {
        SlippyMapPreferences.setMapUrl(this.tileSourceCombo.getSelectedItem().toString());
        SlippyMapPreferences.setAutozoom(this.autozoomActive.isSelected());
        SlippyMapPreferences.setAutoloadTiles(this.autoloadTiles.isSelected());
        SlippyMapPreferences.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        SlippyMapPreferences.setFadeBackground((float)this.fadeBackground.getValue() / 100.0f);
        return false;
    }
}

