/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.osb.OsbDownloadLoop;
import org.openstreetmap.josm.plugins.osb.OsbLayer;
import org.openstreetmap.josm.plugins.osb.OsbUploadHook;
import org.openstreetmap.josm.plugins.osb.api.DownloadAction;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;

public class OsbPlugin
extends Plugin
implements Layer.LayerChangeListener {
    private DataSet dataSet;
    private UploadAction.UploadHook uploadHook;
    private OsbDialog dialog;
    private OsbLayer layer;
    public static boolean active = false;
    private DownloadAction download = new DownloadAction();

    public OsbPlugin() {
        this.initConfig();
        this.dataSet = new DataSet();
        this.uploadHook = new OsbUploadHook();
        this.dialog = new OsbDialog(this);
        OsbLayer.listeners.add(this.dialog);
        OsbLayer.listeners.add(this);
    }

    private void initConfig() {
        String include_date;
        String auto_download;
        String uri;
        String debug = Main.pref.get("osb.api.disabled");
        if (debug == null || debug.length() == 0) {
            debug = "false";
            Main.pref.put("osb.api.disabled", debug);
        }
        if ((uri = Main.pref.get("osb.uri.edit")) == null || uri.length() == 0) {
            uri = "http://openstreetbugs.appspot.com/editPOIexec";
            Main.pref.put("osb.uri.edit", uri);
        }
        if ((uri = Main.pref.get("osb.uri.close")) == null || uri.length() == 0) {
            uri = "http://openstreetbugs.appspot.com/closePOIexec";
            Main.pref.put("osb.uri.close", uri);
        }
        if ((uri = Main.pref.get("osb.uri.download")) == null || uri.length() == 0) {
            uri = "http://openstreetbugs.appspot.com/getBugs";
            Main.pref.put("osb.uri.download", uri);
        }
        if ((uri = Main.pref.get("osb.uri.new")) == null || uri.length() == 0) {
            uri = "http://openstreetbugs.appspot.com/addPOIexec";
            Main.pref.put("osb.uri.new", uri);
        }
        if ((auto_download = Main.pref.get("osb.auto_download")) == null || auto_download.length() == 0) {
            auto_download = "true";
            Main.pref.put("osb.auto_download", auto_download);
        }
        if ((include_date = Main.pref.get("osb.include_date")) == null || include_date.length() == 0) {
            include_date = "true";
            Main.pref.put("osb.include_date", include_date);
        }
    }

    protected Bounds bounds() {
        MapView mv = Main.map.mapView;
        return new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
    }

    public void updateData() {
        Bounds bounds = null;
        try {
            bounds = this.bounds();
        }
        catch (Exception e) {
            System.err.println("OpenStreetBugs: Couldn't determine bounds of currently visible rect. Cancel auto update");
            return;
        }
        try {
            this.download.execute(this.dataSet, bounds);
            if (!this.dataSet.nodes.isEmpty()) {
                this.updateGui();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Main.parent, e.getMessage());
            e.printStackTrace();
        }
    }

    public void updateGui() {
        this.dialog.update(this.dataSet);
        this.updateLayer(this.dataSet);
        Main.map.mapView.repaint();
    }

    private void updateLayer(DataSet osbData) {
        if (this.layer == null) {
            this.layer = new OsbLayer(osbData, "OpenStreetBugs");
            Main.main.addLayer((Layer)this.layer);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            newFrame.addToggleDialog((ToggleDialog)this.dialog);
            LinkedList hooks = ((UploadAction)Main.main.menu.upload).uploadHooks;
            hooks.add(0, this.uploadHook);
            final JToggleButton toggle = (JToggleButton)this.dialog.action.button;
            active = toggle.isSelected();
            toggle.addActionListener(new ActionListener(){
                private boolean download = true;

                public void actionPerformed(ActionEvent e) {
                    active = toggle.isSelected();
                    if (toggle.isSelected() && this.download) {
                        Main.worker.execute(new Runnable(){

                            public void run() {
                                OsbPlugin.this.updateData();
                            }
                        });
                        this.download = false;
                    }
                }
            });
        } else if (oldFrame == null || newFrame == null) {
            // empty if block
        }
    }

    public static ImageIcon loadIcon(String name) {
        URL url = OsbPlugin.class.getResource("/images/".concat(name));
        return new ImageIcon(url);
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            active = ((JToggleButton)this.dialog.action.button).isSelected();
            OsbDownloadLoop.getInstance().setPlugin(this);
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == this.layer) {
            this.layer = null;
        }
    }

    public OsbLayer getLayer() {
        return this.layer;
    }

    public void setLayer(OsbLayer layer) {
        this.layer = layer;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }
}

