/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatConfigDialog;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatDg100;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatPlugin;
import org.openstreetmap.josm.tools.I18n;

public class GlobalsatImportDialog
extends JPanel {
    private JOptionPane optionPane;
    private JCheckBox delete;
    private JComboBox portCombo;
    private List<CommPortIdentifier> ports = new LinkedList<CommPortIdentifier>();

    public GlobalsatImportDialog() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.portCombo = new JComboBox();
        this.portCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = ((CommPortIdentifier)object).getName();
                if (string == null) {
                    string = "null";
                }
                return new JLabel(string);
            }
        });
        this.portCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = GlobalsatImportDialog.this.portCombo.getSelectedItem();
                if (object instanceof CommPortIdentifier) {
                    GlobalsatPlugin.setPortIdent((CommPortIdentifier)object);
                    Main.pref.put("globalsat.portIdentifier", ((CommPortIdentifier)object).getName());
                }
            }
        });
        this.refreshPorts();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)new JLabel(I18n.tr((String)"Port:")), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.5;
        this.add((Component)this.portCombo, gridBagConstraints);
        JButton jButton = new JButton(I18n.tr((String)"Refresh"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalsatImportDialog.this.refreshPorts();
            }
        });
        jButton.setToolTipText(I18n.tr((String)"refresh the port list"));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(I18n.tr((String)"Configure"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("configureing the device");
                try {
                    GlobalsatConfigDialog globalsatConfigDialog = new GlobalsatConfigDialog(GlobalsatPlugin.dg100().getConfig());
                    JOptionPane jOptionPane = new JOptionPane(globalsatConfigDialog, -1, 2);
                    JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr((String)"Configure Device"));
                    globalsatConfigDialog.setOptionPane(jOptionPane);
                    jDialog.setVisible(true);
                    if ((Integer)jOptionPane.getValue() == 0) {
                        GlobalsatPlugin.dg100().setConfig(globalsatConfigDialog.getConfig());
                    }
                    jDialog.dispose();
                }
                catch (GlobalsatDg100.ConnectionException connectionException) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Connection Error.") + " " + connectionException.toString());
                }
                System.out.println("configureing the device finised");
            }
        });
        jButton2.setToolTipText(I18n.tr((String)"configure the connected DG100"));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)jButton2, gridBagConstraints);
        this.delete = new JCheckBox(I18n.tr((String)"delete data after import"));
        this.delete.setSelected(Main.pref.getBoolean("globalsat.deleteAfterDownload", false));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.delete, gridBagConstraints);
    }

    public void refreshPorts() {
        String string = Main.pref.get("globalsat.portIdentifier");
        this.portCombo.setVisible(false);
        this.portCombo.removeAllItems();
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1) continue;
            this.portCombo.addItem(commPortIdentifier);
            if (string == null || commPortIdentifier.getName() != string) continue;
            this.portCombo.setSelectedItem(commPortIdentifier);
            GlobalsatPlugin.setPortIdent(commPortIdentifier);
        }
        this.portCombo.setVisible(true);
        GlobalsatPlugin.setPortIdent(this.getPort());
    }

    public boolean deleteFilesAfterDownload() {
        return this.delete.isSelected();
    }

    public CommPortIdentifier getPort() {
        return (CommPortIdentifier)this.portCombo.getSelectedItem();
    }

    public void setOptionPane(JOptionPane jOptionPane) {
        this.optionPane = jOptionPane;
    }
}

