/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.tcx.ActivityLapT;
import org.openstreetmap.josm.io.tcx.ActivityT;
import org.openstreetmap.josm.io.tcx.CourseT;
import org.openstreetmap.josm.io.tcx.PositionT;
import org.openstreetmap.josm.io.tcx.TrackT;
import org.openstreetmap.josm.io.tcx.TrackpointT;
import org.openstreetmap.josm.io.tcx.TrainingCenterDatabaseT;

public class TcxReader {
    private File tcxFile;
    private GpxData gpxData;

    public TcxReader(File file) {
        this.tcxFile = file;
        this.parseFile();
    }

    private void parseFile() {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance(TrainingCenterDatabaseT.class);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(this.tcxFile);
            TrainingCenterDatabaseT trainingCenterDatabaseT = (TrainingCenterDatabaseT)jAXBElement.getValue();
            this.gpxData = new GpxData();
            this.parseDataFromActivities(trainingCenterDatabaseT);
            this.parseDataFromCourses(trainingCenterDatabaseT);
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException(jAXBException);
        }
    }

    private static WayPoint convertPoint(TrackpointT trackpointT) {
        XMLGregorianCalendar xMLGregorianCalendar;
        PositionT positionT = trackpointT.getPosition();
        if (positionT == null) {
            return null;
        }
        WayPoint wayPoint = new WayPoint(new LatLon(positionT.getLatitudeDegrees(), positionT.getLongitudeDegrees()));
        Double d = trackpointT.getAltitudeMeters();
        if (d != null) {
            wayPoint.attr.put("ele", d.toString());
        }
        if ((xMLGregorianCalendar = trackpointT.getTime()) != null) {
            wayPoint.attr.put("time", xMLGregorianCalendar.toString());
            wayPoint.time = 0.001 * (double)xMLGregorianCalendar.toGregorianCalendar().getTimeInMillis();
        }
        return wayPoint;
    }

    private void parseDataFromActivities(TrainingCenterDatabaseT trainingCenterDatabaseT) {
        int n = 0;
        if (trainingCenterDatabaseT.getActivities() != null && trainingCenterDatabaseT.getActivities().getActivity() != null) {
            for (ActivityT activityT : trainingCenterDatabaseT.getActivities().getActivity()) {
                if (activityT.getLap() == null) continue;
                for (ActivityLapT activityLapT : activityT.getLap()) {
                    if (activityLapT.getTrack() == null) continue;
                    XMLGregorianCalendar xMLGregorianCalendar = activityLapT.getStartTime();
                    GpxTrack gpxTrack = new GpxTrack();
                    this.gpxData.tracks.add(gpxTrack);
                    for (TrackT trackT : activityLapT.getTrack()) {
                        if (trackT.getTrackpoint() == null) continue;
                        ArrayList<WayPoint> arrayList = new ArrayList<WayPoint>();
                        gpxTrack.trackSegs.add(arrayList);
                        for (TrackpointT trackpointT : trackT.getTrackpoint()) {
                            WayPoint wayPoint = TcxReader.convertPoint(trackpointT);
                            if (wayPoint == null) continue;
                            if (xMLGregorianCalendar != null) {
                                wayPoint.attr.put("name", "LAP" + ++n);
                                this.gpxData.waypoints.add(wayPoint);
                                xMLGregorianCalendar = null;
                            }
                            arrayList.add(wayPoint);
                        }
                    }
                }
            }
        }
    }

    private void parseDataFromCourses(TrainingCenterDatabaseT trainingCenterDatabaseT) {
        if (trainingCenterDatabaseT.getCourses() != null && trainingCenterDatabaseT.getCourses().getCourse() != null) {
            for (CourseT courseT : trainingCenterDatabaseT.getCourses().getCourse()) {
                if (courseT.getTrack() == null) continue;
                GpxTrack gpxTrack = new GpxTrack();
                this.gpxData.tracks.add(gpxTrack);
                for (TrackT trackT : courseT.getTrack()) {
                    if (trackT.getTrackpoint() == null) continue;
                    ArrayList<WayPoint> arrayList = new ArrayList<WayPoint>();
                    gpxTrack.trackSegs.add(arrayList);
                    for (TrackpointT trackpointT : trackT.getTrackpoint()) {
                        WayPoint wayPoint = TcxReader.convertPoint(trackpointT);
                        if (wayPoint == null) continue;
                        arrayList.add(wayPoint);
                    }
                }
            }
        }
    }

    public GpxData getGpxData() {
        return this.gpxData;
    }
}

