/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import livegps.LiveGpsData;
import livegps.LiveGpsLock;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsLayer
extends GpxLayer
implements PropertyChangeListener {
    public static final String LAYER_NAME = I18n.tr((String)"LiveGPS layer");
    public static final String KEY_LIVEGPS_COLOR = "color.livegps.position";
    LatLon lastPos;
    WayPoint lastPoint;
    GpxTrack trackBeingWritten;
    Collection<WayPoint> trackSegment;
    float speed;
    float course;
    String status;
    boolean autocenter;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public LiveGpsLayer(GpxData gpxData) {
        super(gpxData, LAYER_NAME);
        this.trackBeingWritten = new GpxTrack();
        this.trackBeingWritten.attr.put("desc", "josm live gps");
        this.trackSegment = new ArrayList<WayPoint>();
        this.trackBeingWritten.trackSegs.add(this.trackSegment);
        gpxData.tracks.add(this.trackBeingWritten);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentPosition(double d, double d2) {
        LatLon latLon = new LatLon(d, d2);
        if (this.lastPos != null && latLon.equalsEpsilon(this.lastPos)) {
            return;
        }
        this.lastPos = latLon;
        this.lastPoint = new WayPoint(latLon);
        this.lastPoint.attr.put("time", this.dateFormat.format(new Date()));
        Class<LiveGpsLock> clazz = LiveGpsLock.class;
        synchronized (LiveGpsLock.class) {
            this.trackSegment.add(this.lastPoint);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            if (this.autocenter) {
                this.center();
            }
            return;
        }
    }

    public void center() {
        if (this.lastPoint != null) {
            Main.map.mapView.zoomTo(this.lastPoint.eastNorth, Main.map.mapView.getScale());
        }
    }

    void setSpeed(float f) {
        this.speed = f;
    }

    void setCourse(float f) {
        this.course = f;
    }

    public void setAutoCenter(boolean bl) {
        this.autocenter = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, MapView mapView) {
        Class<LiveGpsLock> clazz = LiveGpsLock.class;
        synchronized (LiveGpsLock.class) {
            super.paint(graphics, mapView);
            if (this.lastPoint != null) {
                Point point = mapView.getPoint(this.lastPoint.eastNorth);
                graphics.setColor(Main.pref.getColor(KEY_LIVEGPS_COLOR, Color.RED));
                graphics.drawOval(point.x - 10, point.y - 10, 20, 20);
                graphics.drawOval(point.x - 9, point.y - 9, 18, 18);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        LiveGpsData liveGpsData;
        if (!this.visible) {
            return;
        }
        if ("gpsdata".equals(propertyChangeEvent.getPropertyName()) && (liveGpsData = (LiveGpsData)propertyChangeEvent.getNewValue()).isFix()) {
            this.setCurrentPosition(liveGpsData.getLatitude(), liveGpsData.getLongitude());
            if (!Float.isNaN(liveGpsData.getSpeed())) {
                this.setSpeed(liveGpsData.getSpeed());
            }
            if (!Float.isNaN(liveGpsData.getCourse())) {
                this.setCourse(liveGpsData.getCourse());
            }
            Main.map.repaint();
        }
    }
}

