/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Point;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Way;

public class LiveGpsData {
    private LatLon latLon;
    private float course;
    private float speed;
    private boolean fix;
    private String wayString;
    private Way way;

    public LiveGpsData(double d, double d2, float f, float f2, boolean bl) {
        this.latLon = new LatLon(d, d2);
        this.course = f;
        this.speed = f2;
        this.fix = bl;
    }

    public LiveGpsData() {
    }

    public float getCourse() {
        return this.course;
    }

    public void setCourse(float f) {
        this.course = f;
    }

    public boolean isFix() {
        return this.fix;
    }

    public void setFix(boolean bl) {
        this.fix = bl;
    }

    public double getLatitude() {
        return this.latLon.lat();
    }

    public double getLongitude() {
        return this.latLon.lon();
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public void setLatLon(LatLon latLon) {
        this.latLon = latLon;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[fix=" + this.fix + ", lat=" + this.latLon.lat() + ", long=" + this.latLon.lon() + ", speed=" + this.speed + ", course=" + this.course + "]";
    }

    public String getWayInfo() {
        if (this.wayString == null) {
            Way way = this.getWay();
            if (way != null) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = way.get("name");
                if (string != null) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append("no name");
                }
                string = way.get("ref");
                if (string != null) {
                    stringBuilder.append(" (").append(string).append(")");
                }
                if ((string = way.get("highway")) != null) {
                    stringBuilder.append(" {").append(string).append("}");
                }
                String string2 = "";
                string = way.get("tunnel");
                if (string != null) {
                    string2 = string2 + "T";
                }
                if ((string = way.get("bridge")) != null) {
                    string2 = string2 + "B";
                }
                if (string2.length() > 0) {
                    stringBuilder.append(" [").append(string2).append("]");
                }
                this.wayString = stringBuilder.toString();
            } else {
                this.wayString = "";
            }
        }
        return this.wayString;
    }

    public Way getWay() {
        if (this.way == null) {
            EastNorth eastNorth = Main.proj.latlon2eastNorth(this.getLatLon());
            Point point = Main.map.mapView.getPoint(eastNorth);
            this.way = Main.map.mapView.getNearestWay(point);
        }
        return this.way;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.course);
        n = 31 * n + (this.latLon == null ? 0 : this.latLon.hashCode());
        n = 31 * n + Float.floatToIntBits(this.speed);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LiveGpsData liveGpsData = (LiveGpsData)object;
        if (Float.floatToIntBits(this.course) != Float.floatToIntBits(liveGpsData.course)) {
            return false;
        }
        if (this.latLon == null ? liveGpsData.latLon != null : !this.latLon.equals((Object)liveGpsData.latLon)) {
            return false;
        }
        return Float.floatToIntBits(this.speed) == Float.floatToIntBits(liveGpsData.speed);
    }
}

