/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsAcquirer
implements Runnable {
    Socket gpsdSocket;
    BufferedReader gpsdReader;
    boolean connected = false;
    String gpsdHost = "localhost";
    int gpsdPort = 2947;
    String configFile = "liveGPS.conf";
    boolean shutdownFlag = false;
    private List<PropertyChangeListener> propertyChangeListener = new ArrayList<PropertyChangeListener>();
    private PropertyChangeEvent lastStatusEvent;
    private PropertyChangeEvent lastDataEvent;

    public LiveGpsAcquirer(String string) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string + this.configFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("No liveGPS.conf found, using defaults");
        }
        if (fileInputStream != null) {
            try {
                properties.load(fileInputStream);
                this.gpsdHost = properties.getProperty("host");
                this.gpsdPort = Integer.parseInt(properties.getProperty("port"));
            }
            catch (IOException iOException) {
                System.err.println("Error while loading liveGPS.conf, using defaults");
            }
            if (this.gpsdHost == null || this.gpsdPort == 0) {
                System.err.println("Error in liveGPS.conf, using defaults");
                this.gpsdHost = "localhost";
                this.gpsdPort = 2947;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.propertyChangeListener.contains(propertyChangeListener)) {
            this.propertyChangeListener.add(propertyChangeListener);
        }
    }

    public void fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus gpsStatus, String string) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "gpsstatus", null, new LiveGpsStatus(gpsStatus, string));
        if (!propertyChangeEvent.equals(this.lastStatusEvent)) {
            this.firePropertyChangeEvent(propertyChangeEvent);
            this.lastStatusEvent = propertyChangeEvent;
        }
    }

    public void fireGpsDataChangeEvent(LiveGpsData liveGpsData, LiveGpsData liveGpsData2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "gpsdata", liveGpsData, liveGpsData2);
        if (!propertyChangeEvent.equals(this.lastDataEvent)) {
            this.firePropertyChangeEvent(propertyChangeEvent);
            this.lastDataEvent = propertyChangeEvent;
        }
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener propertyChangeListener : this.propertyChangeListener) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void run() {
        LiveGpsData liveGpsData = null;
        LiveGpsData liveGpsData2 = null;
        this.shutdownFlag = false;
        while (!this.shutdownFlag) {
            double d = 0.0;
            double d2 = 0.0;
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = false;
            try {
                InetAddress[] inetAddressArray;
                if (!this.connected) {
                    System.out.println("LiveGps tries to connect to gpsd");
                    this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting"));
                    inetAddressArray = InetAddress.getAllByName(this.gpsdHost);
                    for (int i = 0; i < inetAddressArray.length && this.gpsdSocket == null; ++i) {
                        try {
                            this.gpsdSocket = new Socket(inetAddressArray[i], this.gpsdPort);
                            break;
                        }
                        catch (Exception exception) {
                            System.out.println("LiveGps: Could not open connection to gpsd: " + exception);
                            this.gpsdSocket = null;
                            continue;
                        }
                    }
                    if (this.gpsdSocket != null) {
                        this.gpsdReader = new BufferedReader(new InputStreamReader(this.gpsdSocket.getInputStream()));
                        this.gpsdSocket.getOutputStream().write(new byte[]{119, 13, 10});
                        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting"));
                        this.connected = true;
                        System.out.println("LiveGps: Connected to gpsd");
                    }
                }
                if (this.connected) {
                    inetAddressArray = this.gpsdReader.readLine();
                    if (inetAddressArray == null) break;
                    String[] stringArray = inetAddressArray.split(",");
                    if (stringArray.length == 0 || !stringArray[0].equals("GPSD")) continue;
                    for (int i = 1; i < stringArray.length; ++i) {
                        if (stringArray[i].length() < 2 || stringArray[i].charAt(1) != '=') continue;
                        char c = stringArray[i].charAt(0);
                        String string = stringArray[i].substring(2);
                        liveGpsData = liveGpsData2;
                        liveGpsData2 = new LiveGpsData();
                        switch (c) {
                            case 'O': {
                                String[] stringArray2 = string.split("\\s+");
                                if (stringArray2.length < 5) break;
                                d = Double.parseDouble(stringArray2[3]);
                                d2 = Double.parseDouble(stringArray2[4]);
                                try {
                                    f = Float.parseFloat(stringArray2[9]);
                                    f2 = Float.parseFloat(stringArray2[8]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                bl = true;
                                break;
                            }
                            case 'P': {
                                String[] stringArray3 = string.split("\\s+");
                                if (stringArray3.length < 2) break;
                                d = Double.parseDouble(stringArray3[0]);
                                d2 = Double.parseDouble(stringArray3[1]);
                                f = Float.NaN;
                                f2 = Float.NaN;
                                bl = true;
                            }
                        }
                        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTED, I18n.tr((String)"Connected"));
                        liveGpsData2.setFix(bl);
                        if (!bl) continue;
                        liveGpsData2.setLatLon(new LatLon(d, d2));
                        liveGpsData2.setSpeed(f);
                        liveGpsData2.setCourse(f2);
                        this.fireGpsDataChangeEvent(liveGpsData, liveGpsData2);
                    }
                    continue;
                }
                this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.DISCONNECTED, I18n.tr((String)"Not connected"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (IOException iOException) {
                this.connected = false;
                if (liveGpsData2 != null) {
                    liveGpsData2.setFix(false);
                    this.fireGpsDataChangeEvent(liveGpsData, liveGpsData2);
                }
                this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTION_FAILED, I18n.tr((String)"Connection Failed"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.DISCONNECTED, I18n.tr((String)"Not connected"));
        if (this.gpsdSocket != null) {
            try {
                this.gpsdSocket.close();
                this.gpsdSocket = null;
                System.out.println("LiveGps: Disconnected from gpsd");
            }
            catch (Exception exception) {
                System.out.println("LiveGps: Unable to close socket; reconnection may not be possible");
            }
        }
    }

    public void shutdown() {
        this.shutdownFlag = true;
    }
}

