/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.GeorefImage;
import wmsplugin.WMSLayer;

public class WMSAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    GeorefImage selectedImage;
    WMSLayer selectedLayer;
    boolean mouseDown;
    EastNorth prevEastNorth;

    public WMSAdjustAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Adjust WMS"), "adjustwms", I18n.tr((String)"Adjust the position of the selected WMS layer"), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Layer layer = Main.map.mapView.getActiveLayer();
        if (layer.visible && layer instanceof WMSLayer) {
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.selectedLayer = (WMSLayer)layer;
            this.selectedImage = this.selectedLayer.findImage(this.prevEastNorth);
            if (this.selectedImage != null) {
                Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.selectedImage != null) {
            EastNorth eastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.selectedLayer.displace(eastNorth.east() - this.prevEastNorth.east(), eastNorth.north() - this.prevEastNorth.north());
            this.prevEastNorth = eastNorth;
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.repaint();
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.selectedImage = null;
        this.prevEastNorth = null;
        this.selectedLayer = null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof WMSLayer && l.visible;
    }
}

