/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojDialog;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojPlugin;
import org.openstreetmap.josm.plugins.agpifoj.CorrelateGpxWithImages;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgpifojLayer
extends Layer {
    List<ImageEntry> data;
    private Icon icon = ImageProvider.get((String)"dialogs/agpifoj-marker");
    private Icon selectedIcon = ImageProvider.get((String)"dialogs/agpifoj-marker-selected");
    private int currentPhoto = -1;
    public boolean hasTimeoffset = false;
    public long timeoffset = 0L;
    private MouseAdapter mouseAdapter = null;

    public static void create(File[] fileArray) {
        Loader loader = new Loader(fileArray);
        Main.worker.execute((Runnable)((Object)loader));
    }

    private AgpifojLayer(List<ImageEntry> list) {
        super(I18n.tr((String)"Geotagged Images"));
        Collections.sort(list);
        this.data = list;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"dialogs/agpifoj");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        JMenuItem jMenuItem = new JMenuItem(I18n.tr((String)"Correlate to GPX"), ImageProvider.get((String)"dialogs/gpx2img"));
        jMenuItem.addActionListener(new CorrelateGpxWithImages(this));
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JMenuItem((Action)new RenameLayerAction(null, (Layer)this)), new JSeparator(), jMenuItem};
    }

    public String getToolTipText() {
        int n = 0;
        for (ImageEntry imageEntry : this.data) {
            if (imageEntry.pos == null) continue;
            ++n;
        }
        return this.data.size() + " " + I18n.trn((String)"image", (String)"images", (long)this.data.size()) + " loaded. " + I18n.tr((String)"{0} were found to be gps tagged.", (Object[])new Object[]{n});
    }

    public boolean isMergable(Layer layer) {
        return layer instanceof AgpifojLayer;
    }

    public void mergeFrom(Layer layer) {
        AgpifojLayer agpifojLayer = (AgpifojLayer)layer;
        ImageEntry imageEntry = null;
        if (agpifojLayer.currentPhoto >= 0) {
            imageEntry = agpifojLayer.data.get(agpifojLayer.currentPhoto);
        }
        this.data.addAll(agpifojLayer.data);
        Collections.sort(this.data);
        if (this.data.size() > 1) {
            ImageEntry imageEntry2 = this.data.get(this.data.size() - 1);
            for (int i = this.data.size() - 2; i >= 0; --i) {
                ImageEntry imageEntry3 = this.data.get(i);
                if (imageEntry3.file.equals(imageEntry2.file)) {
                    this.data.remove(i);
                    continue;
                }
                imageEntry2 = imageEntry3;
            }
        }
        if (imageEntry != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i) != imageEntry) continue;
                this.currentPhoto = i;
                AgpifojDialog.showImage(this, this.data.get(i));
                break;
            }
        }
        this.name = agpifojLayer.name;
    }

    public void paint(Graphics graphics, MapView mapView) {
        Cloneable cloneable;
        int n = this.icon.getIconWidth() / 2;
        int n2 = this.icon.getIconHeight() / 2;
        for (ImageEntry object : this.data) {
            if (object.pos == null) continue;
            cloneable = mapView.getPoint(object.pos);
            Rectangle rectangle = new Rectangle(cloneable.x - n, cloneable.y - n2, this.icon.getIconWidth(), this.icon.getIconHeight());
            this.icon.paintIcon((Component)mapView, graphics, rectangle.x, rectangle.y);
        }
        if (this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            ImageEntry imageEntry = this.data.get(this.currentPhoto);
            if (imageEntry.pos != null) {
                Point point = mapView.getPoint(imageEntry.pos);
                cloneable = new Rectangle(point.x - this.selectedIcon.getIconWidth() / 2, point.y - this.selectedIcon.getIconHeight() / 2, this.selectedIcon.getIconWidth(), this.selectedIcon.getIconHeight());
                this.selectedIcon.paintIcon((Component)mapView, graphics, ((Rectangle)cloneable).x, ((Rectangle)cloneable).y);
            }
        }
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (ImageEntry imageEntry : this.data) {
            boundingXYVisitor.visit(imageEntry.pos);
        }
    }

    private static void extractExif(ImageEntry imageEntry) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata((File)imageEntry.file);
            Directory directory = metadata.getDirectory(GpsDirectory.class);
            Rational[] rationalArray = directory.getRationalArray(4);
            int n = rationalArray[0].intValue();
            float f = rationalArray[1].floatValue();
            float f2 = rationalArray[2].floatValue();
            double d = (float)n + f / 60.0f + f2 / 3600.0f;
            if (directory.getString(3).charAt(0) == 'W') {
                d = -d;
            }
            rationalArray = directory.getRationalArray(2);
            n = rationalArray[0].intValue();
            f = rationalArray[1].floatValue();
            f2 = rationalArray[2].floatValue();
            double d2 = (float)n + f / 60.0f + f2 / 3600.0f;
            if (directory.getString(1).charAt(0) == 'S') {
                d2 = -d2;
            }
            imageEntry.exifCoor = imageEntry.coor = new LatLon(d2, d);
            imageEntry.pos = Main.proj.latlon2eastNorth(imageEntry.coor);
        }
        catch (Exception exception) {
            imageEntry.coor = null;
            imageEntry.pos = null;
        }
    }

    public void showNextPhoto() {
        if (this.data != null && this.data.size() > 0) {
            ++this.currentPhoto;
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            AgpifojDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showPreviousPhoto() {
        if (this.data != null && this.data.size() > 0) {
            --this.currentPhoto;
            if (this.currentPhoto < 0) {
                this.currentPhoto = 0;
            }
            AgpifojDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void removeCurrentPhoto() {
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            this.data.remove(this.currentPhoto);
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            if (this.currentPhoto >= 0) {
                AgpifojDialog.showImage(this, this.data.get(this.currentPhoto));
            } else {
                AgpifojDialog.showImage(this, null);
            }
        }
        Main.map.repaint();
    }

    private void hook_up_mouse_events() {
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (AgpifojLayer.this.visible) {
                    Main.map.mapView.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (!AgpifojLayer.this.visible) {
                    return;
                }
                for (int i = AgpifojLayer.this.data.size() - 1; i >= 0; --i) {
                    ImageEntry imageEntry = AgpifojLayer.this.data.get(i);
                    if (imageEntry.pos == null) continue;
                    Point point = Main.map.mapView.getPoint(imageEntry.pos);
                    Rectangle rectangle = new Rectangle(point.x - AgpifojLayer.this.icon.getIconWidth() / 2, point.y - AgpifojLayer.this.icon.getIconHeight() / 2, AgpifojLayer.this.icon.getIconWidth(), AgpifojLayer.this.icon.getIconHeight());
                    if (!rectangle.contains(mouseEvent.getPoint())) continue;
                    AgpifojLayer.this.currentPhoto = i;
                    AgpifojDialog.showImage(AgpifojLayer.this, imageEntry);
                    Main.map.repaint();
                    break;
                }
                Main.map.mapView.repaint();
            }
        };
        Main.map.mapView.addMouseListener((MouseListener)this.mouseAdapter);
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer layer, Layer layer2) {
                if (layer2 == AgpifojLayer.this && AgpifojLayer.this.currentPhoto >= 0) {
                    Main.map.repaint();
                    AgpifojDialog.showImage(AgpifojLayer.this, AgpifojLayer.this.data.get(AgpifojLayer.this.currentPhoto));
                }
            }

            public void layerAdded(Layer layer) {
            }

            public void layerRemoved(Layer layer) {
                if (layer == AgpifojLayer.this) {
                    Main.map.mapView.removeMouseListener((MouseListener)AgpifojLayer.this.mouseAdapter);
                    AgpifojLayer.this.currentPhoto = -1;
                    AgpifojLayer.this.data.clear();
                    AgpifojLayer.this.data = null;
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Loader
    extends PleaseWaitRunnable {
        private boolean cancelled = false;
        private AgpifojLayer layer;
        private final File[] selection;
        private HashSet<String> loadedDirectories = new HashSet();

        public Loader(File[] fileArray) {
            super(I18n.tr((String)"Extracting GPS locations from EXIF"));
            this.selection = fileArray;
        }

        protected void realRun() throws IOException {
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Starting directory scan"));
            ArrayList<File> arrayList = new ArrayList<File>();
            try {
                this.addRecursiveFiles(arrayList, this.selection);
            }
            catch (NullPointerException nullPointerException) {
                this.errorMessage = this.errorMessage + I18n.tr((String)"One of the selected files was null !!!");
            }
            if (this.cancelled) {
                return;
            }
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Read photos..."));
            ArrayList<ImageEntry> arrayList2 = new ArrayList<ImageEntry>(arrayList.size());
            int n = 0;
            Main.pleaseWaitDlg.progress.setMaximum(arrayList.size());
            Main.pleaseWaitDlg.progress.setValue(n);
            for (File file : arrayList) {
                if (this.cancelled) break;
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Reading {0}...", (Object[])new Object[]{file.getName()}));
                Main.pleaseWaitDlg.progress.setValue(n++);
                ImageEntry imageEntry = new ImageEntry();
                try {
                    imageEntry.time = ExifReader.readTime((File)file);
                }
                catch (ParseException parseException) {
                    imageEntry.time = null;
                }
                imageEntry.file = file;
                AgpifojLayer.extractExif(imageEntry);
                arrayList2.add(imageEntry);
            }
            this.layer = new AgpifojLayer(arrayList2);
            arrayList.clear();
        }

        private void addRecursiveFiles(List<File> list, File[] fileArray) {
            boolean bl = false;
            for (File file : fileArray) {
                if (this.cancelled) break;
                if (file == null) {
                    bl = true;
                    continue;
                }
                if (file.isDirectory()) {
                    String string = null;
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.errorMessage = this.errorMessage + I18n.tr((String)"Unable to get canonical path for directory {0}\n", (Object[])new Object[]{file.getAbsolutePath()});
                    }
                    if (string == null || this.loadedDirectories.contains(string)) continue;
                    this.loadedDirectories.add(string);
                    File[] fileArray2 = file.listFiles(AgpifojPlugin.JPEG_FILE_FILTER);
                    if (fileArray2 != null) {
                        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Scanning directory {0}", (Object[])new Object[]{file.getPath()}));
                        try {
                            this.addRecursiveFiles(list, fileArray2);
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                            this.errorMessage = this.errorMessage + I18n.tr((String)"Found null file in directory {0}\n", (Object[])new Object[]{file.getPath()});
                        }
                        continue;
                    }
                    this.errorMessage = this.errorMessage + I18n.tr((String)"Error while getting files from directory {0}\n", (Object[])new Object[]{file.getPath()});
                    continue;
                }
                list.add(file);
            }
            if (bl) {
                throw new NullPointerException();
            }
        }

        protected void finish() {
            if (this.layer != null) {
                Main.main.addLayer((Layer)this.layer);
                this.layer.hook_up_mouse_events();
                if (!this.cancelled && this.layer.data.size() > 0) {
                    boolean bl = true;
                    for (ImageEntry imageEntry : this.layer.data) {
                        if (imageEntry.pos == null) continue;
                        bl = false;
                    }
                    if (bl) {
                        new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                    }
                }
            }
        }

        protected void cancel() {
            this.cancelled = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ImageEntry
    implements Comparable<ImageEntry> {
        File file;
        Date time;
        LatLon exifCoor;
        LatLon coor;
        EastNorth pos;
        Double speed;
        Double elevation;

        ImageEntry() {
        }

        @Override
        public int compareTo(ImageEntry imageEntry) {
            if (this.time != null && imageEntry.time != null) {
                return this.time.compareTo(imageEntry.time);
            }
            if (this.time == null && imageEntry.time == null) {
                return 0;
            }
            if (this.time == null) {
                return -1;
            }
            return 1;
        }
    }
}

