/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyFunctionTypeWithAssertions;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class SpecificFunctionType
extends AnyFunctionType {
    private SequenceType[] argTypes;
    private SequenceType resultType;
    private AnnotationList annotations;

    public SpecificFunctionType(SequenceType[] argTypes, SequenceType resultType) {
        this.argTypes = argTypes;
        this.resultType = resultType;
        this.annotations = AnnotationList.EMPTY;
    }

    public SpecificFunctionType(SequenceType[] argTypes, SequenceType resultType, AnnotationList annotations) {
        this.argTypes = argTypes;
        this.resultType = resultType;
        this.annotations = annotations;
    }

    public int getArity() {
        return this.argTypes.length;
    }

    public SequenceType[] getArgumentTypes() {
        return this.argTypes;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public AnnotationList getAnnotationAssertions() {
        return this.annotations;
    }

    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("(function(");
        for (int i = 0; i < this.argTypes.length; ++i) {
            sb.append(this.argTypes[i].toString());
            if (i >= this.argTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") as ");
        sb.append(this.resultType.toString());
        sb.append(')');
        return sb.toString();
    }

    public String toExportString() {
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("(function(");
        for (int i = 0; i < this.argTypes.length; ++i) {
            sb.append(this.argTypes[i].toExportString());
            if (i >= this.argTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") as ");
        sb.append(this.resultType.toExportString());
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof SpecificFunctionType) {
            SpecificFunctionType f2 = (SpecificFunctionType)other;
            if (!this.resultType.equals(f2.resultType)) {
                return false;
            }
            if (this.argTypes.length != f2.argTypes.length) {
                return false;
            }
            for (int i = 0; i < this.argTypes.length; ++i) {
                if (this.argTypes[i].equals(f2.argTypes[i])) continue;
                return false;
            }
            return this.getAnnotationAssertions().equals(f2.getAnnotationAssertions());
        }
        return false;
    }

    public int hashCode() {
        int h2 = this.resultType.hashCode() ^ this.argTypes.length;
        for (SequenceType argType : this.argTypes) {
            h2 ^= argType.hashCode();
        }
        return h2;
    }

    public int relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance() || other instanceof AnyFunctionTypeWithAssertions) {
            return 2;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (other instanceof ArrayItemType || other instanceof MapType) {
            int rrel = other.relationship(this, th);
            switch (rrel) {
                case 1: {
                    return 4;
                }
                case 2: {
                    return 1;
                }
            }
            return rrel;
        }
        if (this.argTypes.length != other.getArgumentTypes().length) {
            return 4;
        }
        boolean wider = false;
        boolean narrower = false;
        block16: for (int i = 0; i < this.argTypes.length; ++i) {
            int argRel = th.sequenceTypeRelationship(this.argTypes[i], other.getArgumentTypes()[i]);
            switch (argRel) {
                case 4: {
                    return 4;
                }
                case 1: {
                    narrower = true;
                    continue block16;
                }
                case 2: {
                    wider = true;
                    continue block16;
                }
                case 3: {
                    wider = true;
                    narrower = true;
                    continue block16;
                }
            }
        }
        int resRel = th.sequenceTypeRelationship(this.resultType, other.getResultType());
        switch (resRel) {
            case 4: {
                return 4;
            }
            case 1: {
                wider = true;
                break;
            }
            case 2: {
                narrower = true;
                break;
            }
            case 3: {
                wider = true;
                narrower = true;
                break;
            }
        }
        if (wider) {
            if (narrower) {
                return 3;
            }
            return 1;
        }
        if (narrower) {
            return 2;
        }
        return 0;
    }

    public boolean matches(Item item, TypeHierarchy th) {
        if (!(item instanceof Function)) {
            return false;
        }
        if (item instanceof MapItem) {
            if (this.getArity() == 1 && this.argTypes[0].getCardinality() == 16384 && this.argTypes[0].getPrimaryType().isPlainType()) {
                for (KeyValuePair pair : (MapItem)item) {
                    try {
                        if (this.resultType.matches(pair.value, th)) continue;
                        return false;
                    }
                    catch (XPathException e) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (item instanceof ArrayItem) {
            if (this.getArity() == 1 && this.argTypes[0].getCardinality() == 16384 && this.argTypes[0].getPrimaryType().isPlainType()) {
                int rel = th.relationship(this.argTypes[0].getPrimaryType(), BuiltInAtomicType.INTEGER);
                if (rel != 0 && rel != 2) {
                    return false;
                }
                for (Sequence member : (ArrayItem)item) {
                    try {
                        if (this.resultType.matches(member, th)) continue;
                        return false;
                    }
                    catch (XPathException e) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        int rel = th.relationship(((Function)item).getFunctionItemType(), this);
        return rel == 0 || rel == 2;
    }

    public Expression makeFunctionSequenceCoercer(Expression exp, RoleDiagnostic role) throws XPathException {
        return exp.getConfiguration().makeFunctionSequenceCoercer(this, exp, role);
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        this.resultType.getPrimaryType().visitNamedSchemaComponents(visitor);
        for (SequenceType argType : this.argTypes) {
            argType.getPrimaryType().visitNamedSchemaComponents(visitor);
        }
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        throw new XPathException("Cannot generate JS code for function type tests", "SXJS0001");
    }
}

