/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.SequenceExtent;

public class ArrayIterator
implements UnfailingIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator {
    protected Item[] items;
    private int index;
    protected int start;
    protected int end;

    public ArrayIterator(Item[] nodes) {
        this.items = nodes;
        this.start = 0;
        this.end = nodes.length;
        this.index = 0;
    }

    public ArrayIterator(Item[] items, int start, int end) {
        this.items = items;
        this.end = end;
        this.start = start;
        this.index = start;
    }

    public SequenceIterator makeSliceIterator(int min2, int max) {
        int newEnd;
        int newStart;
        Item[] items = this.getArray();
        int currentStart = this.getStartPosition();
        int currentEnd = this.getEndPosition();
        if (min2 < 1) {
            min2 = 1;
        }
        if ((newStart = currentStart + (min2 - 1)) < currentStart) {
            newStart = currentStart;
        }
        int n = newEnd = max == Integer.MAX_VALUE ? currentEnd : newStart + max - min2 + 1;
        if (newEnd > currentEnd) {
            newEnd = currentEnd;
        }
        if (newEnd <= newStart) {
            return EmptyIterator.emptyIterator();
        }
        return new ArrayIterator(items, newStart, newEnd);
    }

    public boolean hasNext() {
        return this.index < this.end;
    }

    public Item next() {
        if (this.index >= this.end) {
            this.index = this.end + 1;
            return null;
        }
        return this.items[this.index++];
    }

    public int getLength() {
        return this.end - this.start;
    }

    public void close() {
    }

    public Item[] getArray() {
        return this.items;
    }

    public int getStartPosition() {
        return this.start;
    }

    public int getEndPosition() {
        return this.end;
    }

    public GroundedValue materialize() {
        SequenceExtent seq;
        if (this.start == 0 && this.end == this.items.length) {
            seq = new SequenceExtent(this.items);
        } else {
            List<Item> sublist = Arrays.asList(this.items).subList(this.start, this.end);
            seq = new SequenceExtent(sublist);
        }
        return seq.reduce();
    }

    public GroundedValue getResidue() throws XPathException {
        SequenceExtent seq;
        if (this.start == 0 && this.index == 0 && this.end == this.items.length) {
            seq = new SequenceExtent(this.items);
        } else {
            List<Item> sublist = Arrays.asList(this.items).subList(this.start + this.index, this.end);
            seq = new SequenceExtent(sublist);
        }
        return seq.reduce();
    }

    public int getProperties() {
        return 7;
    }

    public static class OfNodes
    extends ArrayIterator
    implements AxisIterator {
        public OfNodes(NodeInfo[] list) {
            super(list);
        }

        public NodeInfo next() {
            return (NodeInfo)super.next();
        }
    }
}

