/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.Collections;
import java.util.Set;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.TraceListener2;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.TextOnlyCopyRuleSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mode
extends Actor {
    public static final StructuredQName OMNI_MODE = new StructuredQName("saxon", "http://saxon.sf.net/", "_omniMode");
    public static final StructuredQName UNNAMED_MODE_NAME = new StructuredQName("xsl", "http://www.w3.org/1999/XSL/Transform", "unnamed");
    public static final StructuredQName DEFAULT_MODE_NAME = new StructuredQName("xsl", "http://www.w3.org/1999/XSL/Transform", "default");
    protected StructuredQName modeName;
    private boolean streamable;
    private int recoveryPolicy = 1;
    public boolean mustBeTyped = false;
    public boolean mustBeUntyped = false;
    boolean hasRules = false;
    boolean bindingSlotsAllocated = false;
    private Set<? extends Accumulator> accumulators;

    public Mode(StructuredQName modeName) {
        this.modeName = modeName;
    }

    @Override
    public Component.M getDeclaringComponent() {
        return (Component.M)super.getDeclaringComponent();
    }

    public abstract BuiltInRuleSet getBuiltInRuleSet();

    public boolean isUnnamedMode() {
        return this.modeName.equals(UNNAMED_MODE_NAME);
    }

    public StructuredQName getModeName() {
        return this.modeName;
    }

    public abstract SimpleMode getActivePart();

    public abstract int getMaxPrecedence();

    public abstract int getMaxRank();

    public abstract void computeRankings(int var1) throws XPathException;

    public String getModeTitle() {
        return this.isUnnamedMode() ? "The unnamed mode" : "Mode " + this.getModeName().getDisplayName();
    }

    public Set<? extends Accumulator> getAccumulators() {
        return this.accumulators == null ? Collections.emptySet() : this.accumulators;
    }

    public void setAccumulators(Set<? extends Accumulator> accumulators) {
        this.accumulators = accumulators;
    }

    @Override
    public int getComponentKind() {
        return 174;
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName(174, this.getModeName());
    }

    @Override
    public int getConstructType() {
        return 174;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.getModeName();
    }

    public abstract boolean isEmpty();

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public void setHasRules(boolean hasRules) {
        this.hasRules = hasRules;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setStreamable(boolean streamable) {
        this.streamable = streamable;
    }

    public boolean isDeclaredStreamable() {
        return this.streamable;
    }

    public abstract Set<String> getExplicitNamespaces(NamePool var1);

    public abstract void processRules(RuleAction var1) throws XPathException;

    public XPathContext makeNewContext(XPathContext context) {
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(context.getController());
        c2.openStackFrame(this.getStackFrameSlotsNeeded());
        if (!(context.getCurrentComponent().getActor() instanceof Accumulator)) {
            c2.setCurrentComponent(context.getCurrentMode());
        }
        return c2;
    }

    protected XPathContext makeNewContextIfNeeded(XPathContext context) {
        if (this.getStackFrameSlotsNeeded() > 0) {
            context = this.makeNewContext(context);
        }
        return context;
    }

    public abstract Rule getRule(Item var1, XPathContext var2) throws XPathException;

    public abstract Rule getRule(Item var1, XPathContext var2, RuleFilter var3) throws XPathException;

    public Rule getRule(Item item, final int min2, final int max, XPathContext context) throws XPathException {
        RuleFilter filter = new RuleFilter(){

            public boolean testRule(Rule r) {
                int p = r.getPrecedence();
                return p >= min2 && p <= max;
            }
        };
        return this.getRule(item, context, filter);
    }

    public Rule getNextMatchRule(Item item, final Rule currentRule, XPathContext context) throws XPathException {
        RuleFilter filter = new RuleFilter(){

            public boolean testRule(Rule r) {
                int comp = r.compareRank(currentRule);
                return comp < 0 || comp == 0 && r.getSequence() < currentRule.getSequence();
            }
        };
        return this.getRule(item, context, filter);
    }

    public abstract void exportTemplateRules(ExpressionPresenter var1) throws XPathException;

    public abstract void explainTemplateRules(ExpressionPresenter var1) throws XPathException;

    public TailCall applyTemplates(ParameterSet parameters, ParameterSet tunnelParameters, XPathContextMajor context, Location locationId) throws XPathException {
        Controller controller = context.getController();
        boolean tracing = controller.isTracing();
        PipelineConfiguration pipe = context.getReceiver().getPipelineConfiguration();
        FocusIterator iterator = context.getCurrentIterator();
        TailCall tc = null;
        TraceListener traceListener = tracing ? controller.getTraceListener() : null;
        boolean lookahead = (iterator.getProperties() & 4) != 0;
        TemplateRule previousTemplate = null;
        while (true) {
            int kind;
            SchemaType annotation;
            Item item;
            if (tc != null) {
                if (lookahead && !((LookaheadIterator)((Object)iterator)).hasNext()) break;
                while ((tc = tc.processLeavingTail()) != null) {
                }
            }
            if ((item = iterator.next()) == null) break;
            if (this.mustBeTyped) {
                int kind2;
                if (!(!(item instanceof NodeInfo) || (kind2 = ((NodeInfo)item).getNodeKind()) != 1 && kind2 != 2 || (annotation = ((NodeInfo)item).getSchemaType()) != Untyped.getInstance() && annotation != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    throw new XPathException(this.getModeTitle() + " requires typed nodes, but the input is untyped", "XTTE3100");
                }
            } else if (this.mustBeUntyped && item instanceof NodeInfo && ((kind = ((NodeInfo)item).getNodeKind()) == 1 || kind == 2) && (annotation = ((NodeInfo)item).getSchemaType()) != Untyped.getInstance() && annotation != BuiltInAtomicType.UNTYPED_ATOMIC) {
                throw new XPathException(this.getModeTitle() + " requires untyped nodes, but the input is typed", "XTTE3110");
            }
            pipe.pushCurrentAppliedItem(item);
            if (tracing && traceListener instanceof TraceListener2) {
                ((TraceListener2)traceListener).startRuleSearch();
            }
            Rule rule = this.getRule(item, context);
            if (tracing && traceListener instanceof TraceListener2) {
                ((TraceListener2)traceListener).endRuleSearch(rule != null ? rule : this.getBuiltInRuleSet(), this, item);
            }
            if (rule == null) {
                this.getBuiltInRuleSet().process(item, parameters, tunnelParameters, context, locationId);
            } else {
                TemplateRule template = (TemplateRule)rule.getAction();
                if (template != previousTemplate) {
                    previousTemplate = template;
                    template.initialize();
                    context.openStackFrame(template.getStackFrameMap());
                    context.setLocalParameters(parameters);
                    context.setTunnelParameters(tunnelParameters);
                }
                context.setCurrentTemplateRule(rule);
                if (tracing) {
                    traceListener.startCurrentItem(item);
                    tc = template.applyLeavingTail(context);
                    if (tc != null) {
                        while ((tc = tc.processLeavingTail()) != null) {
                        }
                    }
                    traceListener.endCurrentItem(item);
                } else {
                    tc = template.applyLeavingTail(context);
                }
            }
            pipe.popCurrentAppliedItem();
        }
        return tc;
    }

    public abstract int getStackFrameSlotsNeeded();

    public String getCodeForBuiltInRuleSet(BuiltInRuleSet builtInRuleSet) {
        if (builtInRuleSet instanceof TextOnlyCopyRuleSet) {
            return "TC";
        }
        return "???";
    }

    public BuiltInRuleSet getBuiltInRuleSetForCode(String code) throws XPathException {
        if (code.startsWith("TC")) {
            return TextOnlyCopyRuleSet.getInstance();
        }
        throw new AssertionError();
    }

    @Override
    public final void export(ExpressionPresenter presenter) throws XPathException {
        int s2 = presenter.startElement("mode");
        if (!this.isUnnamedMode()) {
            presenter.emitAttribute("name", this.getModeName().getEQName());
        }
        presenter.emitAttribute("onNo", this.getCodeForBuiltInRuleSet(this.getBuiltInRuleSet()));
        String flags = "";
        if (this.isDeclaredStreamable()) {
            flags = flags + "s";
        }
        if (this.isUnnamedMode()) {
            flags = flags + "d";
        }
        if (this.mustBeTyped) {
            flags = flags + "t";
        }
        if (this.mustBeUntyped) {
            flags = flags + "u";
        }
        if (this.recoveryPolicy == 2) {
            flags = flags + "F";
        } else if (this.recoveryPolicy == 1) {
            flags = flags + "W";
        }
        if (!this.hasRules) {
            flags = flags + "e";
        }
        if (!flags.isEmpty()) {
            presenter.emitAttribute("flags", flags);
        }
        this.exportUseAccumulators(presenter);
        presenter.emitAttribute("patternSlots", this.getStackFrameSlotsNeeded() + "");
        this.exportTemplateRules(presenter);
        int e = presenter.endElement();
        if (s2 != e) {
            throw new IllegalStateException("Export tree unbalanced for mode " + this.getModeName());
        }
    }

    protected void exportUseAccumulators(ExpressionPresenter presenter) {
    }

    public boolean isMustBeTyped() {
        return this.mustBeTyped;
    }

    public void explain(ExpressionPresenter presenter) throws XPathException {
        int s2 = presenter.startElement("mode");
        if (!this.isUnnamedMode()) {
            presenter.emitAttribute("name", this.getModeName());
        }
        presenter.emitAttribute("onNo", this.getCodeForBuiltInRuleSet(this.getBuiltInRuleSet()));
        String flags = "";
        if (this.isDeclaredStreamable()) {
            flags = flags + "s";
        }
        if (this.isUnnamedMode()) {
            flags = flags + "d";
        }
        if (this.mustBeTyped) {
            flags = flags + "t";
        }
        if (this.mustBeUntyped) {
            flags = flags + "u";
        }
        if (this.recoveryPolicy == 2) {
            flags = flags + "F";
        } else if (this.recoveryPolicy == 1) {
            flags = flags + "W";
        }
        if (!flags.isEmpty()) {
            presenter.emitAttribute("flags", flags);
        }
        presenter.emitAttribute("patternSlots", this.getStackFrameSlotsNeeded() + "");
        this.explainTemplateRules(presenter);
        int e = presenter.endElement();
        if (s2 != e) {
            throw new IllegalStateException("tree unbalanced");
        }
    }

    public static interface RuleAction {
        public void processRule(Rule var1) throws XPathException;
    }

    protected static interface RuleFilter {
        public boolean testRule(Rule var1);
    }
}

