/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;

public class SingletonIntersectExpression
extends VennExpression {
    public SingletonIntersectExpression(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    public Expression simplify() throws XPathException {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    public Expression copy(RebindingMap rebindings) {
        SingletonIntersectExpression exp = new SingletonIntersectExpression(this.getLhsExpression().copy(rebindings), this.operator, this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        NodeInfo n;
        NodeInfo m3 = (NodeInfo)this.getLhsExpression().evaluateItem(c);
        if (m3 == null) {
            return EmptyIterator.getInstance();
        }
        SequenceIterator iter = this.getRhsExpression().iterate(c);
        while ((n = (NodeInfo)iter.next()) != null) {
            if (!n.isSameNodeInfo(m3)) continue;
            return SingletonIterator.makeIterator(m3);
        }
        return EmptyIterator.getInstance();
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        NodeInfo m3 = (NodeInfo)this.getLhsExpression().evaluateItem(c);
        return m3 != null && SingletonIntersectExpression.containsNode(this.getRhsExpression().iterate(c), m3);
    }

    public static boolean containsNode(SequenceIterator iter, NodeInfo m3) throws XPathException {
        NodeInfo n;
        while ((n = (NodeInfo)iter.next()) != null) {
            if (!n.isSameNodeInfo(m3)) continue;
            iter.close();
            return true;
        }
        return false;
    }

    public String getExpressionName() {
        return "singleton-intersect";
    }

    protected String displayOperator() {
        return "among";
    }

    protected String tag() {
        return "among";
    }
}

