/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.ElementNode;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;

public class RootNode
extends AbstractNode {
    private static final String ROOT_NAME = "ROOT";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];
    private final DetailAST detailAst;

    public RootNode(DetailAST detailAst) {
        super(new GenericTreeInfo(Configuration.newConfiguration()));
        this.detailAst = detailAst;
        if (detailAst != null) {
            this.createChildren();
        }
    }

    private void createChildren() {
        for (DetailAST currentChild = this.detailAst; currentChild != null; currentChild = currentChild.getNextSibling()) {
            ElementNode child = new ElementNode(this, this, currentChild);
            this.addChild(child);
        }
    }

    @Override
    public String getAttributeValue(String namespace, String localPart) {
        throw RootNode.throwUnsupportedOperationException();
    }

    @Override
    public String getLocalPart() {
        return ROOT_NAME;
    }

    @Override
    public int getNodeKind() {
        return 9;
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this;
    }

    @Override
    public String getStringValue() {
        return ROOT_NAME;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        AxisIterator result;
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 9: {
                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 1: 
            case 12: {
                result = SingleNodeIterator.makeIterator(this);
                break;
            }
            case 3: {
                if (this.hasChildNodes()) {
                    result = new ArrayIterator.OfNodes(this.getChildren().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
                    break;
                }
                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 4: {
                if (this.hasChildNodes()) {
                    result = new Navigator.DescendantEnumeration(this, false, true);
                    break;
                }
                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 5: {
                result = new Navigator.DescendantEnumeration(this, true, true);
                break;
            }
            default: {
                throw RootNode.throwUnsupportedOperationException();
            }
        }
        return result;
    }

    @Override
    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    @Override
    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return 1;
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

