/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AstTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.DetailNodeTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.SuppressionsStringPrinter;
import com.puppycrawl.tools.checkstyle.ThreadModeSettings;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.XpathFileGeneratorAstFilter;
import com.puppycrawl.tools.checkstyle.XpathFileGeneratorAuditListener;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.RootModule;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Main {
    public static final String ERROR_COUNTER = "Main.errorCounter";
    public static final String LOAD_PROPERTIES_EXCEPTION = "Main.loadProperties";
    public static final String CREATE_LISTENER_EXCEPTION = "Main.createListener";
    private static final Log LOG = LogFactory.getLog(Main.class);
    private static final int HELP_WIDTH = 100;
    private static final int EXIT_WITH_CHECKSTYLE_EXCEPTION_CODE = -2;
    private static final String OPTION_V_NAME = "v";
    private static final String OPTION_C_NAME = "c";
    private static final String OPTION_F_NAME = "f";
    private static final String OPTION_P_NAME = "p";
    private static final String OPTION_O_NAME = "o";
    private static final String OPTION_S_NAME = "s";
    private static final String OPTION_T_NAME = "t";
    private static final String OPTION_TREE_NAME = "tree";
    private static final String OPTION_TAB_WIDTH_NAME = "tabWidth";
    private static final String OPTION_CAPITAL_T_NAME = "T";
    private static final String OPTION_TREE_COMMENT_NAME = "treeWithComments";
    private static final String OPTION_J_NAME = "j";
    private static final String OPTION_JAVADOC_TREE_NAME = "javadocTree";
    private static final String OPTION_CAPITAL_J_NAME = "J";
    private static final String OPTION_TREE_JAVADOC_NAME = "treeWithJavadoc";
    private static final String OPTION_D_NAME = "d";
    private static final String OPTION_DEBUG_NAME = "debug";
    private static final String OPTION_E_NAME = "e";
    private static final String OPTION_EXCLUDE_NAME = "exclude";
    private static final String OPTION_EXECUTE_IGNORED_MODULES_NAME = "executeIgnoredModules";
    private static final String OPTION_X_NAME = "x";
    private static final String OPTION_EXCLUDE_REGEXP_NAME = "exclude-regexp";
    private static final String OPTION_CAPITAL_C_NAME = "C";
    private static final String OPTION_CHECKER_THREADS_NUMBER_NAME = "checker-threads-number";
    private static final String OPTION_CAPITAL_W_NAME = "W";
    private static final String OPTION_TREE_WALKER_THREADS_NUMBER_NAME = "tree-walker-threads-number";
    private static final String OPTION_GXS_NAME = "gxs";
    private static final String OPTION_GENERATE_XPATH_SUPPRESSION_NAME = "generate-xpath-suppression";
    private static final String XML_FORMAT_NAME = "xml";
    private static final String PLAIN_FORMAT_NAME = "plain";
    private static final String ONE_STRING_VALUE = "1";
    private static final String DEFAULT_TAB_WIDTH = "8";

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String ... args) throws IOException {
        int exitStatus;
        block15: {
            int errorCounter = 0;
            boolean cliViolations = false;
            int exitWithCliViolation = -1;
            exitStatus = 0;
            try {
                CommandLine commandLine = Main.parseCli(args);
                if (commandLine.hasOption(OPTION_V_NAME)) {
                    System.out.println("Checkstyle version: " + Main.class.getPackage().getImplementationVersion());
                    exitStatus = 0;
                } else {
                    List<File> filesToProcess = Main.getFilesToProcess(Main.getExclusions(commandLine), commandLine.getArgs());
                    List<String> messages = Main.validateCli(commandLine, filesToProcess);
                    boolean bl = cliViolations = !messages.isEmpty();
                    if (cliViolations) {
                        exitStatus = -1;
                        errorCounter = 1;
                        messages.forEach(System.out::println);
                    } else {
                        exitStatus = errorCounter = Main.runCli(commandLine, filesToProcess);
                    }
                }
                if (errorCounter == 0 || cliViolations) break block15;
            }
            catch (ParseException pex) {
                block16: {
                    cliViolations = true;
                    exitStatus = -1;
                    errorCounter = 1;
                    System.out.println(pex.getMessage());
                    Main.printUsage();
                    if (errorCounter == 0 || cliViolations) break block16;
                    LocalizedMessage errorCounterMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", ERROR_COUNTER, new String[]{String.valueOf(errorCounter)}, null, Main.class, null);
                    System.out.println(errorCounterMessage.getMessage());
                }
                if (exitStatus != 0) {
                    System.exit(exitStatus);
                }
            }
            catch (CheckstyleException ex) {
                block17: {
                    exitStatus = -2;
                    errorCounter = 1;
                    ex.printStackTrace();
                    if (errorCounter == 0 || cliViolations) break block17;
                    {
                        catch (Throwable throwable) {
                            if (errorCounter != 0 && !cliViolations) {
                                LocalizedMessage errorCounterMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", ERROR_COUNTER, new String[]{String.valueOf(errorCounter)}, null, Main.class, null);
                                System.out.println(errorCounterMessage.getMessage());
                            }
                            if (exitStatus != 0) {
                                System.exit(exitStatus);
                            }
                            throw throwable;
                        }
                    }
                    LocalizedMessage errorCounterMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", ERROR_COUNTER, new String[]{String.valueOf(errorCounter)}, null, Main.class, null);
                    System.out.println(errorCounterMessage.getMessage());
                }
                if (exitStatus != 0) {
                    System.exit(exitStatus);
                }
            }
            LocalizedMessage errorCounterMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", ERROR_COUNTER, new String[]{String.valueOf(errorCounter)}, null, Main.class, null);
            System.out.println(errorCounterMessage.getMessage());
        }
        if (exitStatus != 0) {
            System.exit(exitStatus);
        }
    }

    private static CommandLine parseCli(String ... args) throws ParseException {
        DefaultParser clp = new DefaultParser();
        return clp.parse(Main.buildOptions(), args);
    }

    private static List<Pattern> getExclusions(CommandLine commandLine) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        if (commandLine.hasOption(OPTION_E_NAME)) {
            for (String value : commandLine.getOptionValues(OPTION_E_NAME)) {
                result.add(Pattern.compile("^" + Pattern.quote(new File(value).getAbsolutePath()) + "$"));
            }
        }
        if (commandLine.hasOption(OPTION_X_NAME)) {
            for (String value : commandLine.getOptionValues(OPTION_X_NAME)) {
                result.add(Pattern.compile(value));
            }
        }
        return result;
    }

    private static List<String> validateCli(CommandLine cmdLine, List<File> filesToProcess) {
        ArrayList<String> result = new ArrayList<String>();
        if (filesToProcess.isEmpty()) {
            result.add("Files to process must be specified, found 0.");
        } else if (cmdLine.hasOption(OPTION_T_NAME) || cmdLine.hasOption(OPTION_CAPITAL_T_NAME) || cmdLine.hasOption(OPTION_J_NAME) || cmdLine.hasOption(OPTION_CAPITAL_J_NAME)) {
            if (cmdLine.hasOption(OPTION_S_NAME) || cmdLine.hasOption(OPTION_C_NAME) || cmdLine.hasOption(OPTION_P_NAME) || cmdLine.hasOption(OPTION_F_NAME) || cmdLine.hasOption(OPTION_O_NAME)) {
                result.add("Option '-t' cannot be used with other options.");
            } else if (filesToProcess.size() > 1) {
                result.add("Printing AST is allowed for only one file.");
            }
        } else if (cmdLine.hasOption(OPTION_S_NAME)) {
            if (cmdLine.hasOption(OPTION_C_NAME) || cmdLine.hasOption(OPTION_P_NAME) || cmdLine.hasOption(OPTION_F_NAME) || cmdLine.hasOption(OPTION_O_NAME)) {
                result.add("Option '-s' cannot be used with other options.");
            } else if (filesToProcess.size() > 1) {
                result.add("Printing xpath suppressions is allowed for only one file.");
            }
        } else if (cmdLine.hasOption(OPTION_C_NAME)) {
            String propertiesLocation;
            File file;
            String format;
            String configLocation = cmdLine.getOptionValue(OPTION_C_NAME);
            try {
                CommonUtil.getUriByFilename(configLocation);
            }
            catch (CheckstyleException ignored) {
                result.add(String.format("Could not find config XML file '%s'.", configLocation));
            }
            if (cmdLine.hasOption(OPTION_F_NAME) && !PLAIN_FORMAT_NAME.equals(format = cmdLine.getOptionValue(OPTION_F_NAME)) && !XML_FORMAT_NAME.equals(format)) {
                result.add(String.format("Invalid output format. Found '%s' but expected '%s' or '%s'.", format, PLAIN_FORMAT_NAME, XML_FORMAT_NAME));
            }
            if (cmdLine.hasOption(OPTION_P_NAME) && !(file = new File(propertiesLocation = cmdLine.getOptionValue(OPTION_P_NAME))).exists()) {
                result.add(String.format("Could not find file '%s'.", propertiesLocation));
            }
            Main.verifyThreadsNumberParameter(cmdLine, result, OPTION_CAPITAL_C_NAME, "Checker threads number must be greater than zero", "Invalid Checker threads number");
            Main.verifyThreadsNumberParameter(cmdLine, result, OPTION_CAPITAL_W_NAME, "TreeWalker threads number must be greater than zero", "Invalid TreeWalker threads number");
        } else {
            result.add("Must specify a config XML file.");
        }
        return result;
    }

    private static void verifyThreadsNumberParameter(CommandLine cmdLine, List<String> result, String cliParameterName, String mustBeGreaterThanZeroMessage, String invalidNumberMessage) {
        if (cmdLine.hasOption(cliParameterName)) {
            String checkerThreadsNumberStr = cmdLine.getOptionValue(cliParameterName);
            if (CommonUtil.isInt(checkerThreadsNumberStr)) {
                int checkerThreadsNumber = Integer.parseInt(checkerThreadsNumberStr);
                if (checkerThreadsNumber < 1) {
                    result.add(mustBeGreaterThanZeroMessage);
                }
            } else {
                result.add(invalidNumberMessage);
            }
        }
    }

    private static int runCli(CommandLine commandLine, List<File> filesToProcess) throws IOException, CheckstyleException {
        int result = 0;
        CliOptions config = Main.convertCliToPojo(commandLine, filesToProcess);
        if (commandLine.hasOption(OPTION_T_NAME)) {
            File file = (File)config.files.get(0);
            String stringAst = AstTreeStringPrinter.printFileAst(file, JavaParser.Options.WITHOUT_COMMENTS);
            System.out.print(stringAst);
        } else if (commandLine.hasOption(OPTION_CAPITAL_T_NAME)) {
            File file = (File)config.files.get(0);
            String stringAst = AstTreeStringPrinter.printFileAst(file, JavaParser.Options.WITH_COMMENTS);
            System.out.print(stringAst);
        } else if (commandLine.hasOption(OPTION_J_NAME)) {
            File file = (File)config.files.get(0);
            String stringAst = DetailNodeTreeStringPrinter.printFileAst(file);
            System.out.print(stringAst);
        } else if (commandLine.hasOption(OPTION_CAPITAL_J_NAME)) {
            File file = (File)config.files.get(0);
            String stringAst = AstTreeStringPrinter.printJavaAndJavadocTree(file);
            System.out.print(stringAst);
        } else if (commandLine.hasOption(OPTION_S_NAME)) {
            File file = (File)config.files.get(0);
            String suppressionLineColumnNumber = config.suppressionLineColumnNumber;
            int tabWidth = config.tabWidth;
            String stringSuppressions = SuppressionsStringPrinter.printSuppressions(file, suppressionLineColumnNumber, tabWidth);
            System.out.print(stringSuppressions);
        } else {
            if (commandLine.hasOption(OPTION_D_NAME)) {
                Logger parentLogger = Logger.getLogger(Main.class.getName()).getParent();
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.FINEST);
                handler.setFilter(new Filter(){
                    private final String packageName = Main.class.getPackage().getName();

                    @Override
                    public boolean isLoggable(LogRecord record) {
                        return record.getLoggerName().startsWith(this.packageName);
                    }
                });
                parentLogger.addHandler(handler);
                parentLogger.setLevel(Level.FINEST);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checkstyle debug logging enabled");
                LOG.debug("Running Checkstyle with version: " + Main.class.getPackage().getImplementationVersion());
            }
            result = Main.runCheckstyle(config);
        }
        return result;
    }

    private static CliOptions convertCliToPojo(CommandLine cmdLine, List<File> filesToProcess) {
        CliOptions conf = new CliOptions();
        conf.format = cmdLine.getOptionValue(OPTION_F_NAME);
        if (conf.format == null) {
            conf.format = PLAIN_FORMAT_NAME;
        }
        conf.outputLocation = cmdLine.getOptionValue(OPTION_O_NAME);
        conf.configLocation = cmdLine.getOptionValue(OPTION_C_NAME);
        conf.propertiesLocation = cmdLine.getOptionValue(OPTION_P_NAME);
        conf.suppressionLineColumnNumber = cmdLine.getOptionValue(OPTION_S_NAME);
        conf.files = filesToProcess;
        conf.executeIgnoredModules = cmdLine.hasOption(OPTION_EXECUTE_IGNORED_MODULES_NAME);
        String checkerThreadsNumber = cmdLine.getOptionValue(OPTION_CAPITAL_C_NAME, ONE_STRING_VALUE);
        conf.checkerThreadsNumber = Integer.parseInt(checkerThreadsNumber);
        String treeWalkerThreadsNumber = cmdLine.getOptionValue(OPTION_CAPITAL_W_NAME, ONE_STRING_VALUE);
        conf.treeWalkerThreadsNumber = Integer.parseInt(treeWalkerThreadsNumber);
        String tabWidth = cmdLine.getOptionValue(OPTION_TAB_WIDTH_NAME, DEFAULT_TAB_WIDTH);
        conf.tabWidth = Integer.parseInt(tabWidth);
        conf.generateXpathSuppressionsFile = cmdLine.hasOption(OPTION_GENERATE_XPATH_SUPPRESSION_NAME);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runCheckstyle(CliOptions cliOptions) throws CheckstyleException, IOException {
        int errorCounter;
        Properties props = cliOptions.propertiesLocation == null ? System.getProperties() : Main.loadProperties(new File(cliOptions.propertiesLocation));
        ThreadModeSettings multiThreadModeSettings = new ThreadModeSettings(cliOptions.checkerThreadsNumber, cliOptions.treeWalkerThreadsNumber);
        ConfigurationLoader.IgnoredModulesOptions ignoredModulesOptions = cliOptions.executeIgnoredModules ? ConfigurationLoader.IgnoredModulesOptions.EXECUTE : ConfigurationLoader.IgnoredModulesOptions.OMIT;
        Configuration config = ConfigurationLoader.loadConfiguration(cliOptions.configLocation, (PropertyResolver)new PropertiesExpander(props), ignoredModulesOptions, multiThreadModeSettings);
        ClassLoader moduleClassLoader = Checker.class.getClassLoader();
        RootModule rootModule = Main.getRootModule(config.getName(), moduleClassLoader);
        try {
            AuditListener listener;
            if (cliOptions.generateXpathSuppressionsFile) {
                Configuration treeWalkerConfig = Main.getTreeWalkerConfig(config);
                if (treeWalkerConfig != null) {
                    DefaultConfiguration moduleConfig = new DefaultConfiguration(XpathFileGeneratorAstFilter.class.getName());
                    moduleConfig.addAttribute(OPTION_TAB_WIDTH_NAME, Integer.toString(cliOptions.tabWidth));
                    ((DefaultConfiguration)treeWalkerConfig).addChild(moduleConfig);
                }
                listener = new XpathFileGeneratorAuditListener(System.out, AutomaticBean.OutputStreamOptions.NONE);
            } else {
                listener = Main.createListener(cliOptions.format, cliOptions.outputLocation);
            }
            rootModule.setModuleClassLoader(moduleClassLoader);
            rootModule.configure(config);
            rootModule.addListener(listener);
            errorCounter = rootModule.process(cliOptions.files);
        }
        finally {
            rootModule.destroy();
        }
        return errorCounter;
    }

    private static Configuration getTreeWalkerConfig(Configuration config) {
        Configuration[] children;
        Configuration result = null;
        for (Configuration child : children = config.getChildren()) {
            if (!"TreeWalker".equals(child.getName())) continue;
            result = child;
            break;
        }
        return result;
    }

    private static RootModule getRootModule(String name, ClassLoader moduleClassLoader) throws CheckstyleException {
        PackageObjectFactory factory = new PackageObjectFactory(Checker.class.getPackage().getName(), moduleClassLoader);
        return (RootModule)factory.createModule(name);
    }

    private static Properties loadProperties(File file) throws CheckstyleException {
        Properties properties = new Properties();
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(stream);
        }
        catch (IOException ex) {
            LocalizedMessage loadPropertiesExceptionMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", LOAD_PROPERTIES_EXCEPTION, new String[]{file.getAbsolutePath()}, null, Main.class, null);
            throw new CheckstyleException(loadPropertiesExceptionMessage.getMessage(), ex);
        }
        return properties;
    }

    private static AuditListener createListener(String format, String outputLocation) throws IOException {
        AutomaticBean listener;
        if (XML_FORMAT_NAME.equals(format)) {
            OutputStream out = Main.getOutputStream(outputLocation);
            AutomaticBean.OutputStreamOptions closeOutputStreamOption = Main.getOutputStreamOptions(outputLocation);
            listener = new XMLLogger(out, closeOutputStreamOption);
        } else if (PLAIN_FORMAT_NAME.equals(format)) {
            OutputStream out = Main.getOutputStream(outputLocation);
            AutomaticBean.OutputStreamOptions closeOutputStreamOption = Main.getOutputStreamOptions(outputLocation);
            listener = new DefaultLogger(out, closeOutputStreamOption);
        } else {
            LocalizedMessage outputFormatExceptionMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", CREATE_LISTENER_EXCEPTION, new String[]{format, PLAIN_FORMAT_NAME, XML_FORMAT_NAME}, null, Main.class, null);
            throw new IllegalStateException(outputFormatExceptionMessage.getMessage());
        }
        return listener;
    }

    private static OutputStream getOutputStream(String outputLocation) throws IOException {
        OutputStream result = outputLocation == null ? System.out : Files.newOutputStream(Paths.get(outputLocation, new String[0]), new OpenOption[0]);
        return result;
    }

    private static AutomaticBean.OutputStreamOptions getOutputStreamOptions(String outputLocation) {
        AutomaticBean.OutputStreamOptions result = outputLocation == null ? AutomaticBean.OutputStreamOptions.NONE : AutomaticBean.OutputStreamOptions.CLOSE;
        return result;
    }

    private static List<File> getFilesToProcess(List<Pattern> patternsToExclude, String ... filesToProcess) {
        LinkedList<File> files = new LinkedList<File>();
        for (String element : filesToProcess) {
            files.addAll(Main.listFiles(new File(element), patternsToExclude));
        }
        return files;
    }

    private static List<File> listFiles(File node, List<Pattern> patternsToExclude) {
        LinkedList<File> result = new LinkedList<File>();
        if (node.canRead()) {
            if (node.isDirectory()) {
                File[] files;
                if (!Main.isDirectoryExcluded(node.getAbsolutePath(), patternsToExclude) && (files = node.listFiles()) != null) {
                    for (File element : files) {
                        result.addAll(Main.listFiles(element, patternsToExclude));
                    }
                }
            } else if (node.isFile()) {
                result.add(node);
            }
        }
        return result;
    }

    private static boolean isDirectoryExcluded(String path, List<Pattern> patternsToExclude) {
        boolean result = false;
        for (Pattern pattern : patternsToExclude) {
            if (!pattern.matcher(path).find()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp(String.format("java %s [options] -c <config.xml> file...", Main.class.getName()), Main.buildOptions());
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption(OPTION_C_NAME, true, "Sets the check configuration file to use.");
        options.addOption(OPTION_O_NAME, true, "Sets the output file. Defaults to stdout");
        options.addOption(OPTION_P_NAME, true, "Loads the properties file");
        options.addOption(OPTION_S_NAME, true, "Print xpath suppressions at the file's line and column position. Argument is the line and column number (separated by a : ) in the file that the suppression should be generated for");
        options.addOption(OPTION_TAB_WIDTH_NAME, true, String.format("Sets the length of the tab character. Used only with \"-s\" option. Default value is %s", DEFAULT_TAB_WIDTH));
        options.addOption(OPTION_GXS_NAME, OPTION_GENERATE_XPATH_SUPPRESSION_NAME, false, "Generates to output a suppression.xml to use to suppress all violations from user's config");
        options.addOption(OPTION_F_NAME, true, String.format("Sets the output format. (%s|%s). Defaults to %s", PLAIN_FORMAT_NAME, XML_FORMAT_NAME, PLAIN_FORMAT_NAME));
        options.addOption(OPTION_V_NAME, false, "Print product version and exit");
        options.addOption(OPTION_T_NAME, OPTION_TREE_NAME, false, "Print Abstract Syntax Tree(AST) of the file");
        options.addOption(OPTION_CAPITAL_T_NAME, OPTION_TREE_COMMENT_NAME, false, "Print Abstract Syntax Tree(AST) of the file including comments");
        options.addOption(OPTION_J_NAME, OPTION_JAVADOC_TREE_NAME, false, "Print Parse tree of the Javadoc comment");
        options.addOption(OPTION_CAPITAL_J_NAME, OPTION_TREE_JAVADOC_NAME, false, "Print full Abstract Syntax Tree of the file");
        options.addOption(OPTION_D_NAME, OPTION_DEBUG_NAME, false, "Print all debug logging of CheckStyle utility");
        options.addOption(OPTION_E_NAME, OPTION_EXCLUDE_NAME, true, "Directory path to exclude from CheckStyle");
        options.addOption(OPTION_X_NAME, OPTION_EXCLUDE_REGEXP_NAME, true, "Regular expression of directory to exclude from CheckStyle");
        options.addOption(OPTION_EXECUTE_IGNORED_MODULES_NAME, false, "Allows ignored modules to be run.");
        options.addOption(OPTION_CAPITAL_C_NAME, OPTION_CHECKER_THREADS_NUMBER_NAME, true, "(experimental) The number of Checker threads (must be greater than zero)");
        options.addOption(OPTION_CAPITAL_W_NAME, OPTION_TREE_WALKER_THREADS_NUMBER_NAME, true, "(experimental) The number of TreeWalker threads (must be greater than zero)");
        return options;
    }

    private static class CliOptions {
        private String propertiesLocation;
        private String configLocation;
        private String format;
        private String outputLocation;
        private List<File> files;
        private boolean executeIgnoredModules;
        private int checkerThreadsNumber;
        private int treeWalkerThreadsNumber;
        private String suppressionLineColumnNumber;
        private int tabWidth;
        private boolean generateXpathSuppressionsFile;

        private CliOptions() {
        }
    }
}

