/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.Util;
import nl.jqno.equalsverifier.internal.reflection.annotations.Annotation;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.NonnullAnnotationVerifier;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;

public class ClassAccessor<T> {
    private static final Map<Map.Entry<String, Annotation>, Boolean> PACKAGE_ANNOTATION_CACHE = Util.newLruCache(512);
    private final Class<T> type;
    private final PrefabValues prefabValues;
    private final Annotation[] supportedAnnotations;
    private final Set<String> ignoredAnnotations;
    private final boolean ignoreAnnotationFailure;
    private final AnnotationAccessor annotationAccessor;

    ClassAccessor(Class<T> type, PrefabValues prefabValues, Annotation[] supportedAnnotations, Set<String> ignoredAnnotations, boolean ignoreAnnotationFailure) {
        this.type = type;
        this.prefabValues = prefabValues;
        this.supportedAnnotations = supportedAnnotations;
        this.ignoredAnnotations = ignoredAnnotations;
        this.ignoreAnnotationFailure = ignoreAnnotationFailure;
        this.annotationAccessor = new AnnotationAccessor(supportedAnnotations, type, ignoredAnnotations, ignoreAnnotationFailure);
    }

    public static <T> ClassAccessor<T> of(Class<T> type, PrefabValues prefabValues, Set<String> ignoredAnnotations, boolean ignoreAnnotationFailure) {
        return new ClassAccessor<T>(type, prefabValues, SupportedAnnotations.values(), ignoredAnnotations, ignoreAnnotationFailure);
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean hasAnnotation(Annotation annotation) {
        return this.annotationAccessor.typeHas(annotation);
    }

    public boolean outerClassHasAnnotation(Annotation annotation) {
        for (Class<?> outer = this.type.getDeclaringClass(); outer != null; outer = outer.getDeclaringClass()) {
            AnnotationAccessor accessor = new AnnotationAccessor(this.supportedAnnotations, outer, this.ignoredAnnotations, this.ignoreAnnotationFailure);
            if (!accessor.typeHas(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean packageHasAnnotation(Annotation annotation) {
        try {
            Package pkg = this.type.getPackage();
            if (pkg == null) {
                return false;
            }
            String packageName = pkg.getName();
            AbstractMap.SimpleImmutableEntry<String, Annotation> entry = new AbstractMap.SimpleImmutableEntry<String, Annotation>(packageName, annotation);
            Boolean hasAnnotation = PACKAGE_ANNOTATION_CACHE.get(entry);
            if (hasAnnotation != null) {
                return hasAnnotation;
            }
            String className = packageName + ".package-info";
            Class<?> packageType = Class.forName(className);
            AnnotationAccessor accessor = new AnnotationAccessor(this.supportedAnnotations, packageType, this.ignoredAnnotations, this.ignoreAnnotationFailure);
            hasAnnotation = accessor.typeHas(annotation);
            PACKAGE_ANNOTATION_CACHE.put(entry, hasAnnotation);
            return hasAnnotation;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean fieldHasAnnotation(Field field, Annotation annotation) {
        return this.annotationAccessor.fieldHas(field.getName(), annotation);
    }

    public boolean declaresField(Field field) {
        try {
            this.type.getDeclaredField(field.getName());
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public boolean declaresEquals() {
        return this.declaresMethod("equals", Object.class);
    }

    public boolean declaresHashCode() {
        return this.declaresMethod("hashCode", new Class[0]);
    }

    private boolean declaresMethod(String name, Class<?> ... parameterTypes) {
        try {
            this.type.getDeclaredMethod(name, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isEqualsAbstract() {
        return this.isMethodAbstract("equals", Object.class);
    }

    public boolean isHashCodeAbstract() {
        return this.isMethodAbstract("hashCode", new Class[0]);
    }

    private boolean isMethodAbstract(String name, Class<?> ... parameterTypes) {
        try {
            return Modifier.isAbstract(this.type.getMethod(name, parameterTypes).getModifiers());
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Should never occur (famous last words)");
        }
    }

    public boolean isEqualsInheritedFromObject() {
        ClassAccessor<T> i = this;
        while (i.getType() != Object.class) {
            if (i.declaresEquals() && !i.isEqualsAbstract()) {
                return false;
            }
            i = i.getSuperAccessor();
        }
        return true;
    }

    public ClassAccessor<? super T> getSuperAccessor() {
        return ClassAccessor.of(this.type.getSuperclass(), this.prefabValues, this.ignoredAnnotations, this.ignoreAnnotationFailure);
    }

    public T getRedObject(TypeTag enclosingType) {
        return this.getRedAccessor(enclosingType).get();
    }

    public ObjectAccessor<T> getRedAccessor(TypeTag enclosingType) {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        result.scramble(this.prefabValues, enclosingType);
        return result;
    }

    public T getBlackObject(TypeTag enclosingType) {
        return this.getBlackAccessor(enclosingType).get();
    }

    public ObjectAccessor<T> getBlackAccessor(TypeTag enclosingType) {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        result.scramble(this.prefabValues, enclosingType);
        result.scramble(this.prefabValues, enclosingType);
        return result;
    }

    public T getDefaultValuesObject(TypeTag enclosingType) {
        return this.getDefaultValuesAccessor(enclosingType, new HashSet<String>()).get();
    }

    public ObjectAccessor<T> getDefaultValuesAccessor(TypeTag enclosingType, Set<String> nonnullFields) {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        for (Field field : FieldIterable.of(this.type)) {
            if (!NonnullAnnotationVerifier.fieldIsNonnull(this, field) && !nonnullFields.contains(field.getName())) continue;
            FieldAccessor accessor = result.fieldAccessorFor(field);
            accessor.changeField(this.prefabValues, enclosingType);
        }
        return result;
    }

    private ObjectAccessor<T> buildObjectAccessor() {
        T object = Instantiator.of(this.type).instantiate();
        return ObjectAccessor.of(object);
    }
}

