/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.NonnullAnnotationVerifier;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.FieldInspector;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class FieldsChecker<T>
implements Checker {
    private final TypeTag typeTag;
    private final ClassAccessor<T> classAccessor;
    private final PrefabValues prefabValues;
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<String> ignoredFields;
    private final Set<String> nonnullFields;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public FieldsChecker(Configuration<T> config) {
        this.typeTag = config.getTypeTag();
        this.classAccessor = config.createClassAccessor();
        this.prefabValues = config.getPrefabValues();
        this.warningsToSuppress = config.getWarningsToSuppress();
        this.ignoredFields = config.getIgnoredFields();
        this.nonnullFields = config.getNonnullFields();
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        FieldInspector<T> inspector = new FieldInspector<T>(this.classAccessor, this.typeTag);
        if (!this.classAccessor.isEqualsInheritedFromObject()) {
            inspector.check(new ArrayFieldCheck());
            inspector.check(new FloatAndDoubleFieldCheck());
            inspector.check(new ReflexivityFieldCheck());
        }
        if (!this.ignoreMutability()) {
            inspector.check(new MutableStateFieldCheck());
        }
        if (!this.warningsToSuppress.contains((Object)Warning.TRANSIENT_FIELDS)) {
            inspector.check(new TransientFieldsCheck());
        }
        inspector.check(new SignificantFieldCheck(false));
        inspector.check(new SymmetryFieldCheck());
        inspector.check(new TransitivityFieldCheck());
        if (!this.warningsToSuppress.contains((Object)Warning.NULL_FIELDS)) {
            inspector.checkWithNull(this.nonnullFields, new SignificantFieldCheck(true));
        }
    }

    private boolean ignoreMutability() {
        return this.warningsToSuppress.contains((Object)Warning.NONFINAL_FIELDS) || this.classAccessor.hasAnnotation(SupportedAnnotations.IMMUTABLE) || this.classAccessor.hasAnnotation(SupportedAnnotations.ENTITY);
    }

    private boolean isCachedHashCodeField(FieldAccessor accessor) {
        return accessor.getFieldName().equals(this.cachedHashCodeInitializer.getCachedHashCodeFieldName());
    }

    private class TransientFieldsCheck
    implements FieldInspector.FieldCheck {
        private TransientFieldsCheck() {
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            boolean fieldIsTransient;
            Object reference = referenceAccessor.getObject();
            Object changed = changedAccessor.getObject();
            changedAccessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
            boolean equalsChanged = !reference.equals(changed);
            boolean bl = fieldIsTransient = referenceAccessor.fieldIsTransient() || FieldsChecker.this.classAccessor.fieldHasAnnotation(referenceAccessor.getField(), SupportedAnnotations.TRANSIENT);
            if (equalsChanged && fieldIsTransient) {
                Assert.fail(Formatter.of("Transient field %% should not be included in equals/hashCode contract.", referenceAccessor.getFieldName()));
            }
            referenceAccessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
        }
    }

    private class MutableStateFieldCheck
    implements FieldInspector.FieldCheck {
        private MutableStateFieldCheck() {
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            boolean equalsChanged;
            if (FieldsChecker.this.isCachedHashCodeField(referenceAccessor)) {
                return;
            }
            Object reference = referenceAccessor.getObject();
            Object changed = changedAccessor.getObject();
            changedAccessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
            boolean bl = equalsChanged = !reference.equals(changed);
            if (equalsChanged && !referenceAccessor.fieldIsFinal()) {
                Assert.fail(Formatter.of("Mutability: equals depends on mutable field %%.", referenceAccessor.getFieldName()));
            }
            referenceAccessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
        }
    }

    private class ReflexivityFieldCheck
    implements FieldInspector.FieldCheck {
        private ReflexivityFieldCheck() {
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            if (FieldsChecker.this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY)) {
                return;
            }
            this.checkReferenceReflexivity(referenceAccessor, changedAccessor);
            this.checkValueReflexivity(referenceAccessor, changedAccessor);
            this.checkNullReflexivity(referenceAccessor, changedAccessor);
        }

        private void checkReferenceReflexivity(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            this.checkReflexivityFor(referenceAccessor, changedAccessor);
        }

        private void checkValueReflexivity(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            Class<?> fieldType = changedAccessor.getFieldType();
            if (FieldsChecker.this.warningsToSuppress.contains((Object)Warning.REFERENCE_EQUALITY)) {
                return;
            }
            if (fieldType.equals(Object.class) || fieldType.isInterface()) {
                return;
            }
            if (changedAccessor.fieldIsStatic()) {
                return;
            }
            ClassAccessor<?> fieldTypeAccessor = ClassAccessor.of(fieldType, FieldsChecker.this.prefabValues, new HashSet<String>(), true);
            if (!fieldTypeAccessor.declaresEquals()) {
                return;
            }
            Object value = changedAccessor.get();
            if (value.getClass().isSynthetic()) {
                return;
            }
            TypeTag tag = TypeTag.of(referenceAccessor.getField(), FieldsChecker.this.typeTag);
            referenceAccessor.set(FieldsChecker.this.prefabValues.giveRed(tag));
            changedAccessor.set(FieldsChecker.this.prefabValues.giveRedCopy(tag));
            Formatter f = Formatter.of("Reflexivity: == used instead of .equals() on field: %%\nIf this is intentional, consider suppressing Warning.%%", changedAccessor.getFieldName(), Warning.REFERENCE_EQUALITY.toString());
            Object left = referenceAccessor.getObject();
            Object right = changedAccessor.getObject();
            Assert.assertEquals(f, left, right);
        }

        private void checkNullReflexivity(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            boolean ignoreNull;
            Field field = referenceAccessor.getField();
            boolean fieldIsPrimitive = referenceAccessor.fieldIsPrimitive();
            boolean fieldIsNonNull = NonnullAnnotationVerifier.fieldIsNonnull(FieldsChecker.this.classAccessor, field);
            boolean bl = ignoreNull = fieldIsNonNull || FieldsChecker.this.warningsToSuppress.contains((Object)Warning.NULL_FIELDS) || FieldsChecker.this.nonnullFields.contains(field.getName());
            if (fieldIsPrimitive || !ignoreNull) {
                referenceAccessor.defaultField();
                changedAccessor.defaultField();
                this.checkReflexivityFor(referenceAccessor, changedAccessor);
            }
        }

        private void checkReflexivityFor(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            Object left = referenceAccessor.getObject();
            Object right = changedAccessor.getObject();
            if (FieldsChecker.this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY)) {
                Assert.assertFalse(Formatter.of("Unnecessary suppression: %%. Two identical copies are equal.", Warning.IDENTICAL_COPY.toString()), left.equals(right));
            } else {
                Formatter f = Formatter.of("Reflexivity: object does not equal an identical copy of itself:\n  %%\nIf this is intentional, consider suppressing Warning.%%", left, Warning.IDENTICAL_COPY.toString());
                Assert.assertEquals(f, left, right);
            }
        }
    }

    private class FloatAndDoubleFieldCheck
    implements FieldInspector.FieldCheck {
        private FloatAndDoubleFieldCheck() {
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            Class<?> type = referenceAccessor.getFieldType();
            if (this.isFloat(type)) {
                referenceAccessor.set(Float.valueOf(Float.NaN));
                changedAccessor.set(Float.valueOf(Float.NaN));
                Assert.assertEquals(Formatter.of("Float: equals doesn't use Float.compare for field %%.", referenceAccessor.getFieldName()), referenceAccessor.getObject(), changedAccessor.getObject());
            }
            if (this.isDouble(type)) {
                referenceAccessor.set(Double.NaN);
                changedAccessor.set(Double.NaN);
                Assert.assertEquals(Formatter.of("Double: equals doesn't use Double.compare for field %%.", referenceAccessor.getFieldName()), referenceAccessor.getObject(), changedAccessor.getObject());
            }
        }

        private boolean isFloat(Class<?> type) {
            return type == Float.TYPE || type == Float.class;
        }

        private boolean isDouble(Class<?> type) {
            return type == Double.TYPE || type == Double.class;
        }
    }

    private class ArrayFieldCheck
    implements FieldInspector.FieldCheck {
        private ArrayFieldCheck() {
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            Class<?> arrayType = referenceAccessor.getFieldType();
            if (!arrayType.isArray()) {
                return;
            }
            if (!referenceAccessor.canBeModifiedReflectively()) {
                return;
            }
            String fieldName = referenceAccessor.getFieldName();
            Object reference = referenceAccessor.getObject();
            Object changed = changedAccessor.getObject();
            this.replaceInnermostArrayValue(changedAccessor);
            if (arrayType.getComponentType().isArray()) {
                this.assertDeep(fieldName, reference, changed);
            } else {
                this.assertArray(fieldName, reference, changed);
            }
        }

        private void replaceInnermostArrayValue(FieldAccessor accessor) {
            Object newArray = this.arrayCopy(accessor.get());
            accessor.set(newArray);
        }

        private Object arrayCopy(Object array) {
            if (array == null) {
                return null;
            }
            Class<?> componentType = array.getClass().getComponentType();
            int length = Array.getLength(array);
            Object result = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                if (componentType.isArray()) {
                    Array.set(result, i, this.arrayCopy(Array.get(array, i)));
                    continue;
                }
                Array.set(result, i, Array.get(array, i));
            }
            return result;
        }

        private void assertDeep(String fieldName, Object reference, Object changed) {
            Formatter eqEqFormatter = Formatter.of("Multidimensional array: ==, regular equals() or Arrays.equals() used instead of Arrays.deepEquals() for field %%.", fieldName);
            Assert.assertEquals(eqEqFormatter, reference, changed);
            Formatter regularFormatter = Formatter.of("Multidimensional array: regular hashCode() or Arrays.hashCode() used instead of Arrays.deepHashCode() for field %%.", fieldName);
            Assert.assertEquals(regularFormatter, FieldsChecker.this.cachedHashCodeInitializer.getInitializedHashCode(reference), FieldsChecker.this.cachedHashCodeInitializer.getInitializedHashCode(changed));
        }

        private void assertArray(String fieldName, Object reference, Object changed) {
            Assert.assertEquals(Formatter.of("Array: == or regular equals() used instead of Arrays.equals() for field %%.", fieldName), reference, changed);
            Assert.assertEquals(Formatter.of("Array: regular hashCode() used instead of Arrays.hashCode() for field %%.", fieldName), FieldsChecker.this.cachedHashCodeInitializer.getInitializedHashCode(reference), FieldsChecker.this.cachedHashCodeInitializer.getInitializedHashCode(changed));
        }
    }

    private class SignificantFieldCheck
    implements FieldInspector.FieldCheck {
        private final boolean skipTestBecause0AndNullBothHaveA0HashCode;

        public SignificantFieldCheck(boolean skipTestBecause0AndNullBothHaveA0HashCode) {
            this.skipTestBecause0AndNullBothHaveA0HashCode = skipTestBecause0AndNullBothHaveA0HashCode;
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            if (FieldsChecker.this.isCachedHashCodeField(referenceAccessor)) {
                return;
            }
            Object reference = referenceAccessor.getObject();
            Object changed = changedAccessor.getObject();
            String fieldName = referenceAccessor.getFieldName();
            if (referenceAccessor.get() == null && NonnullAnnotationVerifier.fieldIsNonnull(FieldsChecker.this.classAccessor, referenceAccessor.getField())) {
                return;
            }
            boolean equalToItself = reference.equals(changed);
            changedAccessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
            boolean equalsChanged = !reference.equals(changed);
            boolean hashCodeChanged = FieldsChecker.this.cachedHashCodeInitializer.getInitializedHashCode(reference) != FieldsChecker.this.cachedHashCodeInitializer.getInitializedHashCode(changed);
            this.assertEqualsAndHashCodeRelyOnSameFields(equalsChanged, hashCodeChanged, reference, changed, fieldName);
            this.assertFieldShouldBeIgnored(equalToItself, equalsChanged, referenceAccessor, fieldName);
            referenceAccessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
        }

        private void assertEqualsAndHashCodeRelyOnSameFields(boolean equalsChanged, boolean hashCodeChanged, Object reference, Object changed, String fieldName) {
            if (equalsChanged != hashCodeChanged) {
                Formatter formatter;
                boolean skipEqualsHasMoreThanHashCodeTest;
                boolean bl = skipEqualsHasMoreThanHashCodeTest = FieldsChecker.this.warningsToSuppress.contains((Object)Warning.STRICT_HASHCODE) || this.skipTestBecause0AndNullBothHaveA0HashCode;
                if (!skipEqualsHasMoreThanHashCodeTest) {
                    formatter = Formatter.of("Significant fields: equals relies on %%, but hashCode does not.\n  %% has hashCode %%\n  %% has hashCode %%", fieldName, reference, reference.hashCode(), changed, changed.hashCode());
                    Assert.assertFalse(formatter, equalsChanged);
                }
                formatter = Formatter.of("Significant fields: hashCode relies on %%, but equals does not.\nThese objects are equal, but probably shouldn't be:\n  %%\nand\n  %%", fieldName, reference, changed);
                Assert.assertFalse(formatter, hashCodeChanged);
            }
        }

        private void assertFieldShouldBeIgnored(boolean equalToItself, boolean equalsChanged, FieldAccessor referenceAccessor, String fieldName) {
            boolean fieldIsEligible;
            boolean allFieldsShouldBeUsed = !FieldsChecker.this.warningsToSuppress.contains((Object)Warning.ALL_FIELDS_SHOULD_BE_USED) && !FieldsChecker.this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY);
            boolean bl = fieldIsEligible = !referenceAccessor.fieldIsStatic() && !referenceAccessor.fieldIsTransient() && !FieldsChecker.this.classAccessor.fieldHasAnnotation(referenceAccessor.getField(), SupportedAnnotations.TRANSIENT) && !referenceAccessor.fieldIsSingleValueEnum();
            if (allFieldsShouldBeUsed && fieldIsEligible) {
                Assert.assertTrue(Formatter.of("Significant fields: equals does not use %%.", fieldName), equalToItself);
                boolean fieldShouldBeIgnored = FieldsChecker.this.ignoredFields.contains(fieldName);
                Assert.assertTrue(Formatter.of("Significant fields: equals does not use %%, or it is stateless.", fieldName), fieldShouldBeIgnored || equalsChanged);
                Assert.assertTrue(Formatter.of("Significant fields: equals should not use %%, but it does.", fieldName), !fieldShouldBeIgnored || !equalsChanged);
            }
        }
    }

    private class TransitivityFieldCheck
    implements FieldInspector.FieldCheck {
        private TransitivityFieldCheck() {
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            Object a1 = referenceAccessor.getObject();
            Object b1 = this.buildB1(changedAccessor);
            Object b2 = this.buildB2(a1, referenceAccessor.getField());
            boolean x = a1.equals(b1);
            boolean y = b1.equals(b2);
            boolean z = a1.equals(b2);
            if (this.countFalses(x, y, z) == 1) {
                Assert.fail(Formatter.of("Transitivity: two of these three instances are equal to each other, so the third one should be, too:\n-  %%\n-  %%\n-  %%", a1, b1, b2));
            }
        }

        private Object buildB1(FieldAccessor accessor) {
            accessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
            return accessor.getObject();
        }

        private Object buildB2(Object a1, Field referenceField) {
            Object result = ObjectAccessor.of(a1).copy();
            ObjectAccessor<Object> objectAccessor = ObjectAccessor.of(result);
            objectAccessor.fieldAccessorFor(referenceField).changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
            for (Field field : FieldIterable.of(result.getClass())) {
                if (field.equals(referenceField)) continue;
                objectAccessor.fieldAccessorFor(field).changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
            }
            return result;
        }

        private int countFalses(boolean ... bools) {
            int result = 0;
            for (boolean b : bools) {
                if (b) continue;
                ++result;
            }
            return result;
        }
    }

    private class SymmetryFieldCheck
    implements FieldInspector.FieldCheck {
        private SymmetryFieldCheck() {
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            this.checkSymmetry(referenceAccessor, changedAccessor);
            changedAccessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
            this.checkSymmetry(referenceAccessor, changedAccessor);
            referenceAccessor.changeField(FieldsChecker.this.prefabValues, FieldsChecker.this.typeTag);
            this.checkSymmetry(referenceAccessor, changedAccessor);
        }

        private void checkSymmetry(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            Object left = referenceAccessor.getObject();
            Object right = changedAccessor.getObject();
            Assert.assertTrue(Formatter.of("Symmetry: objects are not symmetric:\n  %%\nand\n  %%", left, right), left.equals(right) == right.equals(left));
        }
    }
}

