/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;

public enum JodaHelper implements Helper<ReadableInstant>
{
    jodaPattern{

        @Override
        protected CharSequence safeApply(ReadableInstant time, Options options) {
            String pattern = options.param(0, "M d y, H:m:s z");
            return DateTimeFormat.forPattern((String)pattern).print(time);
        }
    }
    ,
    jodaStyle{

        @Override
        protected CharSequence safeApply(ReadableInstant time, Options options) {
            String style = options.param(0, "MM");
            return DateTimeFormat.forStyle((String)style).print(time);
        }
    }
    ,
    jodaISO{

        @Override
        protected CharSequence safeApply(ReadableInstant time, Options options) {
            boolean includeMillis = options.param(1, false);
            if (includeMillis) {
                return ISODateTimeFormat.dateTime().print(time);
            }
            return ISODateTimeFormat.dateTimeNoMillis().print(time);
        }
    };


    @Override
    public Object apply(ReadableInstant time, Options options) throws IOException {
        return this.safeApply(time, options);
    }

    protected abstract CharSequence safeApply(ReadableInstant var1, Options var2);
}

