/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.Location;

public class GettextUtils {
    public static String getJavaLocale(String locale) {
        String lastToken;
        int index;
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> tokens = new ArrayList<String>(3);
        StringTokenizer t = new StringTokenizer(locale, "_");
        while (t.hasMoreTokens()) {
            tokens.add(t.nextToken());
        }
        if (tokens.size() < 1 || tokens.size() > 3) {
            throw new IllegalArgumentException("Invalid locale format: " + locale);
        }
        if (tokens.size() < 3 && (index = (lastToken = (String)tokens.get(tokens.size() - 1)).indexOf("@")) != -1) {
            tokens.remove(tokens.size() - 1);
            tokens.add(lastToken.substring(0, index));
            if (tokens.size() == 1) {
                tokens.add("");
            }
            tokens.add(lastToken.substring(index + 1));
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            String token = (String)it.next();
            sb.append(token);
            if (!it.hasNext()) continue;
            sb.append("_");
        }
        return sb.toString();
    }

    public static String getRelativePath(File file, Location location) {
        String filePath = file.getAbsolutePath();
        File locationParent = new File(location.getFileName()).getParentFile();
        if (locationParent == null) {
            return filePath;
        }
        String locationParentPath = locationParent.getAbsolutePath();
        if (filePath.startsWith(locationParentPath)) {
            if (filePath.length() == locationParentPath.length()) {
                return "";
            }
            return filePath.substring(GettextUtils.getPathWithSeparator(locationParentPath).length());
        }
        int commonPrefixLength = GettextUtils.getCommonPrefix(filePath, locationParentPath).length();
        if (commonPrefixLength > 0) {
            String locationSubPath = locationParentPath.substring(commonPrefixLength);
            int folders = GettextUtils.countOccurrences(locationSubPath, File.separatorChar) + 1;
            String fileSubPath = filePath.substring(commonPrefixLength);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < folders; ++i) {
                builder.append("..").append(File.separatorChar);
            }
            builder.append(fileSubPath);
            return builder.toString();
        }
        return filePath;
    }

    public static String createAbsolutePath(String parentPath, String path) {
        return parentPath + File.separator + path;
    }

    private static String getPathWithSeparator(String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    static String getCommonPrefix(String path1, String path2) {
        int length = Math.min(path1.length(), path2.length());
        for (int i = 0; i < length; ++i) {
            if (path1.charAt(i) == path2.charAt(i)) continue;
            return path1.substring(0, i);
        }
        return path1.substring(0, length);
    }

    static int countOccurrences(String text, char character) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != character) continue;
            ++count;
        }
        return count;
    }
}

