/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.xnap.commons.ant.gettext.AbstractGettextTask;
import org.xnap.commons.ant.gettext.GettextUtils;

public class GettextExtractKeysTask
extends AbstractGettextTask {
    protected Vector filesets = new Vector();
    private String xgettextCommand = "xgettext";
    private String encoding = "utf-8";
    private String keywords = "-ktrc:1c,2 -ktrnc:1c,2,3 -ktr -kmarktr -ktrn:1,2 -k";

    public void addFileSet(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setXgettextCommand(String xgettextCommand) {
        this.xgettextCommand = xgettextCommand;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    private void checkPreconditions() throws BuildException {
        if (this.poDirectory == null) {
            throw new BuildException("poDirectory must be set for xgettext");
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("at least one fileset must be specified to search for .java files in");
        }
    }

    public void execute() {
        this.checkPreconditions();
        ArrayList<String> files = new ArrayList<String>();
        Iterator i = ((AbstractList)this.filesets).iterator();
        while (i.hasNext()) {
            FileSet fileSet = (FileSet)i.next();
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            String[] names = scanner.getIncludedFiles();
            File parent = fileSet.getDir(this.getProject());
            String parentPath = GettextUtils.getRelativePath(parent, this.getLocation());
            this.log(parentPath);
            for (int j = 0; j < names.length; ++j) {
                files.add(GettextUtils.createAbsolutePath(parentPath, names[j]));
            }
        }
        File file = this.createListFile(files);
        Commandline cl = new Commandline();
        cl.setExecutable(this.xgettextCommand);
        cl.createArgument().setValue("-c");
        cl.createArgument().setValue("--from-code=" + this.encoding);
        cl.createArgument().setValue("--output=" + new File(this.poDirectory, this.keysFile).getAbsolutePath());
        cl.createArgument().setValue("--language=Java");
        cl.createArgument().setLine(this.keywords);
        cl.createArgument().setValue("--files-from=" + file.getAbsolutePath());
        this.log("Executing: " + cl.toString());
        this.runCommandLineAndWait(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createListFile(List files) {
        try {
            File listFile = File.createTempFile("srcfiles", null);
            this.log(listFile.getAbsolutePath());
            listFile.deleteOnExit();
            BufferedWriter writer = new BufferedWriter(new FileWriter(listFile));
            try {
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    String file = (String)iterator.next();
                    writer.write(file);
                    writer.newLine();
                }
            }
            finally {
                writer.close();
            }
            return listFile;
        }
        catch (IOException e) {
            this.log(e.getMessage());
            return null;
        }
    }
}

