/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.xnap.commons.ant.gettext.StreamConsumer;

public class AbstractGettextTask
extends Task {
    protected File poDirectory;
    protected String keysFile = "keys.pot";

    public void setPoDirectory(String poDirectory) {
        this.poDirectory = new File(this.getOwningTarget().getProject().getBaseDir(), poDirectory);
        try {
            this.poDirectory = this.poDirectory.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setKeysFile(String keysFile) {
        this.keysFile = keysFile;
    }

    protected void runCommandLineAndWait(Commandline cl) {
        try {
            Process p = Runtime.getRuntime().exec(cl.getCommandline(), null, this.getOwningTarget().getProject().getBaseDir());
            new StreamConsumer(p.getInputStream(), this).start();
            new StreamConsumer(p.getErrorStream(), this).start();
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                this.log(cl.getExecutable() + " returned " + exitCode);
                throw new BuildException("Build failed");
            }
        }
        catch (IOException e) {
            this.log("Could not execute " + cl.getExecutable() + ": " + e.getMessage(), 0);
        }
        catch (InterruptedException e) {
            this.log("Process was interrupted: " + e.getMessage(), 0);
        }
    }
}

