/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapPreferenceSetting
implements PreferenceSetting {
    private JComboBox tileSourceCombo;
    private JCheckBox autozoomActive = new JCheckBox(I18n.tr((String)"autozoom"));
    private JCheckBox autoloadTiles = new JCheckBox(I18n.tr((String)"autoload tiles"));
    private JSpinner maxZoomLvl = new JSpinner();
    private JSlider fadeBackground = new JSlider(0, 100);

    public void addGui(PreferenceDialog gui) {
        JPanel slippymapTab = gui.createPreferenceTab("slippymap.png", I18n.tr((String)"SlippyMap"), I18n.tr((String)"Settings for the SlippyMap plugin."));
        JPanel mapUrlPanel = new JPanel();
        String[] allMapUrls = SlippyMapPreferences.getAllMapUrls();
        this.tileSourceCombo = new JComboBox<String>(allMapUrls);
        this.tileSourceCombo.setEditable(true);
        String source = SlippyMapPreferences.getMapUrl();
        this.tileSourceCombo.setSelectedItem(source);
        mapUrlPanel.add((Component)new JLabel(I18n.tr((String)"Tile Sources")), GBC.std());
        mapUrlPanel.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        mapUrlPanel.add((Component)this.tileSourceCombo, GBC.eol().fill(2));
        JPanel autozoomPanel = new JPanel();
        autozoomPanel.add((Component)new JLabel(I18n.tr((String)"Auto zoom: ")), GBC.std());
        autozoomPanel.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        autozoomPanel.add((Component)this.autozoomActive, GBC.eol().fill(2));
        JPanel autoloadPanel = new JPanel();
        autoloadPanel.add((Component)new JLabel(I18n.tr((String)"Autoload Tiles: ")), GBC.std());
        autoloadPanel.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        autoloadPanel.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        JPanel maxZoomLvlPanel = new JPanel();
        maxZoomLvlPanel.add((Component)new JLabel(I18n.tr((String)"Max zoom lvl: ")), GBC.std());
        maxZoomLvlPanel.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        maxZoomLvlPanel.add((Component)this.maxZoomLvl, GBC.eol().fill(2));
        JPanel fadeBackgroundPanel = new JPanel();
        fadeBackgroundPanel.add((Component)new JLabel(I18n.tr((String)"Fade background: ")), GBC.std());
        fadeBackgroundPanel.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        fadeBackgroundPanel.add((Component)this.fadeBackground, GBC.eol().fill(2));
        slippymapTab.add((Component)mapUrlPanel, GBC.eol().fill(2));
        slippymapTab.add((Component)autozoomPanel, GBC.eol().fill(2));
        slippymapTab.add((Component)autoloadPanel, GBC.eol().fill(2));
        slippymapTab.add((Component)maxZoomLvlPanel, GBC.eol().fill(2));
        slippymapTab.add((Component)fadeBackgroundPanel, GBC.eol().fill(2));
        slippymapTab.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.loadSettings();
    }

    private void loadSettings() {
        this.autozoomActive.setSelected(SlippyMapPreferences.getAutozoom());
        this.autoloadTiles.setSelected(SlippyMapPreferences.getAutoloadTiles());
        this.maxZoomLvl.setValue(SlippyMapPreferences.getMaxZoomLvl());
        this.fadeBackground.setValue(Math.round(SlippyMapPreferences.getFadeBackground() * 100.0f));
    }

    public boolean ok() {
        SlippyMapPreferences.setMapUrl(this.tileSourceCombo.getSelectedItem().toString());
        SlippyMapPreferences.setAutozoom(this.autozoomActive.isSelected());
        SlippyMapPreferences.setAutoloadTiles(this.autoloadTiles.isSelected());
        SlippyMapPreferences.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        SlippyMapPreferences.setFadeBackground((float)this.fadeBackground.getValue() / 100.0f);
        return false;
    }
}

